/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.modca.AbstractPageObject;
import org.apache.fop.render.afp.modca.ActiveEnvironmentGroup;
import org.apache.fop.render.afp.modca.Document;
import org.apache.fop.render.afp.modca.ImageObject;
import org.apache.fop.render.afp.modca.Overlay;
import org.apache.fop.render.afp.modca.PageGroup;
import org.apache.fop.render.afp.modca.PageObject;
import org.apache.fop.render.afp.modca.TagLogicalElementBean;
import org.apache.fop.render.afp.tools.StringUtils;

public class AFPDataStream {
    protected static final Log log = LogFactory.getLog((String)"org.apache.fop.render.afp.modca");
    private boolean _complete = false;
    private String _producer = null;
    private Document _document = null;
    private PageGroup _currentPageGroup = null;
    private PageObject _currentPageObject = null;
    private Overlay _currentOverlay = null;
    private AbstractPageObject _currentPage = null;
    private int _pageCount = 0;
    private int _pageGroupCount = 0;
    private int _ovlCount = 0;
    private int _portraitRotation = 0;
    private int _landscapeRotation = 270;
    private int _xOffset = 0;
    private int _yOffset = 0;
    private int _rotation;
    private OutputStream _outputStream = null;

    public void startDocument(OutputStream outputStream) {
        if (this._document != null) {
            String msg = "Invalid state - document already started.";
            log.warn((Object)("startDocument():: " + msg));
            throw new IllegalStateException(msg);
        }
        this._document = new Document();
        this._outputStream = outputStream;
    }

    public void endDocument() throws IOException {
        if (this._complete) {
            String msg = "Invalid state - document already ended.";
            log.warn((Object)("endDocument():: " + msg));
            throw new IllegalStateException(msg);
        }
        if (this._currentPageObject != null) {
            this.endPage();
        }
        if (this._currentPageGroup != null) {
            this.endPageGroup();
        }
        this._document.endDocument();
        this._document.writeDataStream(this._outputStream);
        this._outputStream.flush();
        this._complete = true;
        this._document = null;
        this._outputStream = null;
    }

    public void startPage(int pageWidth, int pageHeight, int pageRotation) {
        String pageName = "PGN" + StringUtils.lpad(String.valueOf(this._pageCount++), '0', 5);
        this._currentPageObject = new PageObject(pageName, pageWidth, pageHeight, pageRotation);
        this._currentPage = this._currentPageObject;
        this._currentOverlay = null;
        this.setOffsets(0, 0, 0);
    }

    public void startOverlay(int overlayX, int overlayY, int overlayWidth, int overlayHeight, int overlayRotation) {
        String overlayName = "OVL" + StringUtils.lpad(String.valueOf(this._ovlCount++), '0', 5);
        this._currentOverlay = new Overlay(overlayName, overlayWidth, overlayHeight, overlayRotation);
        this._currentPageObject.addOverlay(this._currentOverlay);
        this._currentPageObject.createIncludePageOverlay(overlayName, overlayX, overlayY, 0);
        this._currentPage = this._currentOverlay;
        this.setOffsets(0, 0, 0);
    }

    public void endOverlay() {
        this._currentOverlay.endPage();
        this._currentOverlay = null;
        this._currentPage = this._currentPageObject;
    }

    public PageObject savePage() {
        PageObject pageObject = this._currentPageObject;
        if (this._currentPageGroup != null) {
            this._currentPageGroup.addPage(this._currentPageObject);
        } else {
            this._document.addPage(this._currentPageObject);
        }
        this._currentPageObject = null;
        this._currentPage = null;
        return pageObject;
    }

    public void restorePage(PageObject pageObject) {
        this._currentPageObject = pageObject;
        this._currentPage = pageObject;
    }

    public void endPage() throws IOException {
        this._currentPageObject.endPage();
        if (this._currentPageGroup != null) {
            this._currentPageGroup.addPage(this._currentPageObject);
        } else {
            this._document.addPage(this._currentPageObject);
            this._document.writeDataStream(this._outputStream);
        }
        this._currentPageObject = null;
        this._currentPage = null;
    }

    public void setOffsets(int xOffset, int yOffset, int rotation) {
        this._xOffset = xOffset;
        this._yOffset = yOffset;
        this._rotation = rotation;
    }

    public void createFont(byte fontReference, AFPFont font, int size) {
        this._currentPage.createFont(fontReference, font, size);
    }

    public void createText(int fontNumber, int x, int y, Color col, int vsci, int ica, byte[] data) {
        this._currentPage.createText(fontNumber, x + this._xOffset, y + this._yOffset, this._rotation, col, vsci, ica, data);
    }

    public ImageObject getImageObject(int x, int y, int w, int h) {
        int height;
        int width;
        int yOrigin;
        int xOrigin;
        switch (this._rotation) {
            case 90: {
                xOrigin = this._currentPage.getWidth() - y - this._yOffset;
                yOrigin = x + this._xOffset;
                width = h;
                height = w;
                break;
            }
            case 180: {
                xOrigin = this._currentPage.getWidth() - x - this._xOffset;
                yOrigin = this._currentPage.getHeight() - y - this._yOffset;
                width = w;
                height = h;
                break;
            }
            case 270: {
                xOrigin = y + this._yOffset;
                yOrigin = this._currentPage.getHeight() - x - this._xOffset;
                width = h;
                height = w;
                break;
            }
            default: {
                xOrigin = x + this._xOffset;
                yOrigin = y + this._yOffset;
                width = w;
                height = h;
            }
        }
        ImageObject io = this._currentPage.getImageObject();
        io.setImageViewport(xOrigin, yOrigin, width, height, this._rotation);
        return io;
    }

    public void createLine(int x1, int y1, int x2, int y2, int thickness, Color col) {
        this._currentPage.createLine(x1 + this._xOffset, y1 + this._yOffset, x2 + this._xOffset, y2 + this._yOffset, thickness, this._rotation, col);
    }

    public void createShading(int x, int y, int w, int h, int red, int green, int blue) {
        this._currentPage.createShading(x + this._xOffset, y + this._xOffset, w, h, red, green, blue);
    }

    public void createIncludePageOverlay(String name) {
        this._currentPageObject.createIncludePageOverlay(name, 0, 0, this._rotation);
        ActiveEnvironmentGroup aeg = this._currentPageObject.getActiveEnvironmentGroup();
        aeg.createOverlay(name);
    }

    public void createInvokeMediumMap(String name) {
        if (this._currentPageGroup == null) {
            this.startPageGroup();
        }
        this._currentPageGroup.createInvokeMediumMap(name);
    }

    public void createIncludePageSegment(String name, int x, int y) {
        int yOrigin;
        int xOrigin;
        switch (this._rotation) {
            case 90: {
                xOrigin = this._currentPage.getWidth() - y - this._yOffset;
                yOrigin = x + this._xOffset;
                break;
            }
            case 180: {
                xOrigin = this._currentPage.getWidth() - x - this._xOffset;
                yOrigin = this._currentPage.getHeight() - y - this._yOffset;
                break;
            }
            case 270: {
                xOrigin = y + this._yOffset;
                yOrigin = this._currentPage.getHeight() - x - this._xOffset;
                break;
            }
            default: {
                xOrigin = x + this._xOffset;
                yOrigin = y + this._yOffset;
            }
        }
        this._currentPage.createIncludePageSegment(name, xOrigin, yOrigin);
    }

    public void createPageTagLogicalElement(TagLogicalElementBean[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i].getKey();
            String value = attributes[i].getValue();
            this._currentPage.createTagLogicalElement(name, value);
        }
    }

    public void createPageGroupTagLogicalElement(TagLogicalElementBean[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i].getKey();
            String value = attributes[i].getValue();
            this._currentPageGroup.createTagLogicalElement(name, value);
        }
    }

    public void createTagLogicalElement(String name, String value) {
        if (this._currentPageGroup != null) {
            this._currentPageGroup.createTagLogicalElement(name, value);
        } else {
            this._currentPage.createTagLogicalElement(name, value);
        }
    }

    public void createNoOperation(String content) {
        this._currentPage.createNoOperation(content);
    }

    public void startPageGroup() {
        String pageGroupName = "PGP" + StringUtils.lpad(String.valueOf(this._pageCount++), '0', 5);
        this._currentPageGroup = new PageGroup(pageGroupName);
    }

    public void endPageGroup() throws IOException {
        this._currentPageGroup.endPageGroup();
        this._document.addPageGroup(this._currentPageGroup);
        this._document.writeDataStream(this._outputStream);
        this._currentPageGroup = null;
    }

    public void setPortraitRotation(int rotation) {
        if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
            throw new IllegalArgumentException("The portrait rotation must be one of the values 0, 90, 180, 270");
        }
        this._portraitRotation = rotation;
    }

    public void setLandscapeRotation(int rotation) {
        if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
            throw new IllegalArgumentException("The landscape rotation must be one of the values 0, 90, 180, 270");
        }
        this._landscapeRotation = rotation;
    }
}

