/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.components.language.programming.CompilerError;
import org.apache.cocoon.components.language.programming.LanguageCompiler;
import org.apache.cocoon.util.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class EclipseJavaCompiler
implements LanguageCompiler,
Recyclable {
    boolean debug = true;
    String sourceDir;
    String sourceFile;
    String destDir;
    String sourceEncoding;
    int compilerComplianceLevel;
    List errors = new LinkedList();

    public void recycle() {
        this.sourceFile = null;
        this.sourceDir = null;
        this.destDir = null;
        this.sourceEncoding = null;
        this.errors.clear();
    }

    public void setFile(String file) {
        this.sourceFile = file;
    }

    public void setSource(String srcDir) {
        this.sourceDir = srcDir;
    }

    public void setDestination(String destDir) {
        this.destDir = destDir;
    }

    public void setEncoding(String encoding) {
        this.sourceEncoding = encoding;
    }

    public void setCompilerComplianceLevel(int compilerComplianceLevel) {
        this.compilerComplianceLevel = compilerComplianceLevel;
    }

    public void setClasspath(String cp) {
    }

    private String makeClassName(String fileName) throws IOException {
        File origFile = new File(fileName);
        String canonical = null;
        if (origFile.exists()) {
            canonical = origFile.getCanonicalPath().replace('\\', '/');
        }
        String str = fileName;
        str = str.replace('\\', '/');
        if (this.sourceDir != null) {
            String prefix = new File(this.sourceDir).getCanonicalPath().replace('\\', '/');
            if (canonical != null) {
                if (canonical.startsWith(prefix)) {
                    String result = canonical.substring(prefix.length() + 1, canonical.length() - 5);
                    result = result.replace('/', '.');
                    return result;
                }
            } else {
                File t = new File(this.sourceDir, fileName);
                if (t.exists()) {
                    str = t.getCanonicalPath().replace('\\', '/');
                    String result = str.substring(prefix.length() + 1, str.length() - 5).replace('/', '.');
                    return result;
                }
            }
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        return StringUtils.replaceChars((String)fileName, (String)"\\/", (String)"..");
    }

    public boolean compile() throws IOException {
        final String targetClassName = this.makeClassName(this.sourceFile);
        final ClassLoader classLoader = ClassUtils.getClassLoader();
        String[] fileNames = new String[]{this.sourceFile};
        String[] classNames = new String[]{targetClassName};
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    if (i > 0) {
                        result.append(".");
                    }
                    result.append(compoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < packageName.length; ++i) {
                    if (i > 0) {
                        result.append(".");
                    }
                    result.append(packageName[i]);
                }
                result.append(".");
                result.append(typeName);
                return this.findType(result.toString());
            }

            private NameEnvironmentAnswer findType(String className) {
                try {
                    if (className.equals(targetClassName)) {
                        class CompilationUnit
                        implements ICompilationUnit {
                            String className;
                            String sourceFile;

                            CompilationUnit(String sourceFile, String className) {
                                this.className = className;
                                this.sourceFile = sourceFile;
                            }

                            public char[] getFileName() {
                                return this.className.toCharArray();
                            }

                            public char[] getContents() {
                                char[] result = null;
                                FileReader fr = null;
                                try {
                                    fr = new FileReader(this.sourceFile);
                                    BufferedReader reader = new BufferedReader(fr);
                                    if (reader != null) {
                                        int count;
                                        char[] chars = new char[8192];
                                        StringBuffer buf = new StringBuffer();
                                        while ((count = ((Reader)reader).read(chars, 0, chars.length)) > 0) {
                                            buf.append(chars, 0, count);
                                        }
                                        result = new char[buf.length()];
                                        buf.getChars(0, result.length, result, 0);
                                    }
                                }
                                catch (IOException e) {
                                    EclipseJavaCompiler.this.handleError(this.className, -1, -1, e.getMessage());
                                }
                                return result;
                            }

                            public char[] getMainTypeName() {
                                int dot = this.className.lastIndexOf(46);
                                if (dot > 0) {
                                    return this.className.substring(dot + 1).toCharArray();
                                }
                                return this.className.toCharArray();
                            }

                            public char[][] getPackageName() {
                                StringTokenizer izer = new StringTokenizer(this.className, ".");
                                char[][] result = new char[izer.countTokens() - 1][];
                                for (int i = 0; i < result.length; ++i) {
                                    String tok = izer.nextToken();
                                    result[i] = tok.toCharArray();
                                }
                                return result;
                            }
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(EclipseJavaCompiler.this.sourceFile, className);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit);
                    }
                    String resourceName = className.replace('.', '/') + ".class";
                    InputStream is = classLoader.getResourceAsStream(resourceName);
                    if (is != null) {
                        int count;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            baos.write(buf, 0, count);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader);
                    }
                }
                catch (IOException exc) {
                    EclipseJavaCompiler.this.handleError(className, -1, -1, exc.getMessage());
                }
                catch (ClassFormatException exc) {
                    EclipseJavaCompiler.this.handleError(className, -1, -1, exc.getMessage());
                }
                return null;
            }

            private boolean isPackage(String result) {
                if (result.equals(targetClassName)) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                InputStream is = classLoader.getResourceAsStream(resourceName);
                return is == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String str;
                StringBuffer result = new StringBuffer();
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        if (i > 0) {
                            result.append(".");
                        }
                        result.append(parentPackageName[i]);
                    }
                }
                if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result.toString())) {
                    return false;
                }
                result.append(".");
                result.append(str);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>(9);
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        if (this.sourceEncoding != null) {
            settings.put("org.eclipse.jdt.core.encoding", this.sourceEncoding);
        }
        if (this.debug) {
            settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        switch (this.compilerComplianceLevel) {
            case 150: {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                break;
            }
            case 140: {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
                break;
            }
            default: {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.3");
            }
        }
        switch (SystemUtils.JAVA_VERSION_INT) {
            case 150: {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                break;
            }
            case 140: {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                break;
            }
            default: {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
            }
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                try {
                    if (result.hasErrors()) {
                        IProblem[] errors = result.getErrors();
                        for (int i = 0; i < errors.length; ++i) {
                            IProblem error = errors[i];
                            String name = new String(errors[i].getOriginatingFileName());
                            EclipseJavaCompiler.this.handleError(name, error.getSourceLineNumber(), -1, error.getMessage());
                        }
                    } else {
                        ClassFile[] classFiles = result.getClassFiles();
                        for (int i = 0; i < classFiles.length; ++i) {
                            ClassFile classFile = classFiles[i];
                            char[][] compoundName = classFile.getCompoundName();
                            StringBuffer className = new StringBuffer();
                            for (int j = 0; j < compoundName.length; ++j) {
                                if (j > 0) {
                                    className.append(".");
                                }
                                className.append(compoundName[j]);
                            }
                            byte[] bytes = classFile.getBytes();
                            String outFile = EclipseJavaCompiler.this.destDir + "/" + className.toString().replace('.', '/') + ".class";
                            FileOutputStream fout = new FileOutputStream(outFile);
                            BufferedOutputStream bos = new BufferedOutputStream(fout);
                            bos.write(bytes);
                            bos.close();
                        }
                    }
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[classNames.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            String className = classNames[i];
            compilationUnits[i] = new CompilationUnit(fileNames[i], className);
        }
        Compiler compiler = new Compiler(env, policy, settings, requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        return this.errors.size() == 0;
    }

    void handleError(String className, int line, int column, Object errorMessage) {
        String fileName = className.replace('.', File.separatorChar) + ".java";
        if (column < 0) {
            column = 0;
        }
        this.errors.add(new CompilerError(fileName, true, line, column, line, column, errorMessage.toString()));
    }

    public List getErrors() throws IOException {
        return this.errors;
    }
}

