/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.cocoon.components.language.markup.xsp.XSPObjectHelper;
import org.apache.cocoon.environment.Response;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XSPResponseHelper {
    private static final String URI = "http://apache.org/xsp/response/2.0";
    private static final String PREFIX = "xsp-response";

    public static void getLocale(Response response, ContentHandler handler) throws SAXException {
        Locale locale = response.getLocale();
        XSPObjectHelper.start(URI, PREFIX, handler, "locale");
        XSPObjectHelper.elementData(URI, PREFIX, handler, "language", locale.getLanguage());
        XSPObjectHelper.elementData(URI, PREFIX, handler, "country", locale.getCountry());
        XSPObjectHelper.elementData(URI, PREFIX, handler, "variant", locale.getVariant());
        XSPObjectHelper.end(URI, PREFIX, handler, "locale");
    }

    public static void addDateHeader(Response response, String name, long date) {
        response.addDateHeader(name, date);
    }

    public static void addDateHeader(Response response, String name, Date date) {
        response.addDateHeader(name, date.getTime());
    }

    public static void addDateHeader(Response response, String name, String date) throws ParseException {
        XSPResponseHelper.addDateHeader(response, name, date, DateFormat.getDateInstance());
    }

    public static void addDateHeader(Response response, String name, String date, String format) throws ParseException {
        XSPResponseHelper.addDateHeader(response, name, date, new SimpleDateFormat(format));
    }

    public static void addDateHeader(Response response, String name, String date, DateFormat format) throws ParseException {
        response.addDateHeader(name, format.parse(date).getTime());
    }

    public static void setDateHeader(Response response, String name, long date) {
        response.setDateHeader(name, date);
    }

    public static void setDateHeader(Response response, String name, Date date) {
        response.setDateHeader(name, date.getTime());
    }

    public static void setDateHeader(Response response, String name, String date) throws ParseException {
        XSPResponseHelper.setDateHeader(response, name, date, DateFormat.getDateInstance());
    }

    public static void setDateHeader(Response response, String name, String date, String format) throws ParseException {
        XSPResponseHelper.setDateHeader(response, name, date, new SimpleDateFormat(format));
    }

    public static void setDateHeader(Response response, String name, String date, DateFormat format) throws ParseException {
        response.setDateHeader(name, format.parse(date).getTime());
    }
}

