/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language;

import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.avalon.framework.CascadingException;
import org.apache.cocoon.components.language.programming.CompilerError;

public class LanguageException
extends CascadingException {
    private CompilerError[] errors = null;
    private String filename = null;
    private static final int linesBefore = 3;
    private static final int linesAfter = 3;

    public LanguageException(String message, String filename, CompilerError[] errors) {
        super(message);
        this.filename = filename;
        this.errors = errors;
    }

    public LanguageException(String message) {
        super(message);
    }

    public LanguageException(String message, Throwable t) {
        super(message, t);
    }

    public String getMessage() {
        if (this.errors != null) {
            StringBuffer extendedMessage = new StringBuffer();
            extendedMessage.append(super.getMessage());
            if (this.errors != null && this.filename != null) {
                extendedMessage.append(this.getSource(this.filename));
            }
            for (int i = 0; i < this.errors.length; ++i) {
                CompilerError error = this.errors[i];
                if (i > 0) {
                    extendedMessage.append("\n");
                }
                extendedMessage.append("Line ");
                extendedMessage.append(error.getStartLine());
                extendedMessage.append(", column ");
                extendedMessage.append(error.getStartColumn());
                extendedMessage.append(": ");
                extendedMessage.append(error.getMessage());
            }
            return extendedMessage.toString();
        }
        return super.getMessage();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString());
        if (this.getCause() != null) {
            s.append(": ");
            s.append(this.getCause().toString());
        }
        return s.toString();
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.getCause() != null) {
            this.getCause().printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        }
    }

    private static final String getString(char[] buffer, int start, int end) {
        int currentLine = 1;
        int currentPos = 0;
        while (currentLine < start && currentPos < buffer.length) {
            if (buffer[currentPos++] != '\n') continue;
            ++currentLine;
        }
        int startPos = currentPos;
        while (currentLine < end + 1 && currentPos < buffer.length) {
            if (buffer[currentPos++] != '\n') continue;
            ++currentLine;
        }
        int endPos = currentPos;
        return new String(buffer, startPos, endPos - startPos);
    }

    private String getSource(String filename) {
        File file = new File(filename);
        long fileSize = file.length();
        if (file != null && file.exists() && file.isFile() && fileSize > 0L && (fileSize < Integer.MAX_VALUE || fileSize < 0xA00000L)) {
            char[] buffer = new char[(int)fileSize];
            try {
                FileReader fileReader = new FileReader(file);
                fileReader.read(buffer, 0, (int)fileSize);
                StringBuffer listing = new StringBuffer();
                for (int i = 0; i < this.errors.length; ++i) {
                    CompilerError error = this.errors[i];
                    int start = error.getStartLine();
                    int end = error.getEndLine();
                    if (start <= 0 || end <= 0) continue;
                    String before = LanguageException.getString(buffer, start - 1 - 3, start - 1);
                    String itself = LanguageException.getString(buffer, start, end);
                    String after = LanguageException.getString(buffer, end + 1, end + 1 + 3);
                    listing.append("ERROR ").append(i + 1).append(" (").append(error.getFile()).append("):\n");
                    listing.append("...\n");
                    listing.append(before);
                    listing.append("\n// start error (lines ").append(error.getStartLine()).append("-").append(error.getEndLine()).append(") \"").append(error.getMessage()).append("\"\n");
                    listing.append(itself);
                    listing.append("\n// end error\n");
                    listing.append(after);
                    listing.append("\n...\n");
                }
                fileReader.close();
                return listing.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

