/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.ValidationErrorValue;

public abstract class QualifiedNameValue
extends AtomicValue {
    protected String prefix;
    protected String uri;
    protected String localPart;

    public static AtomicValue makeQName(String string, String string2, String string3, AtomicType atomicType, CharSequence charSequence, TypeHierarchy typeHierarchy) throws XPathException {
        if (atomicType.getFingerprint() == 530) {
            return new QNameValue(string, string2, string3, BuiltInAtomicType.QNAME, null);
        }
        if (typeHierarchy.isSubType(atomicType, BuiltInAtomicType.QNAME)) {
            QNameValue qNameValue = new QNameValue(string, string2, string3, atomicType, null);
            AtomicValue atomicValue = atomicType.setDerivedTypeLabel(qNameValue, charSequence, true);
            if (atomicValue instanceof ValidationErrorValue) {
                throw ((ValidationErrorValue)atomicValue).getException();
            }
            return atomicValue;
        }
        NotationValue notationValue = new NotationValue(string, string2, string3, (AtomicType)null);
        AtomicValue atomicValue = atomicType.setDerivedTypeLabel(notationValue, charSequence, true);
        if (atomicValue instanceof ValidationErrorValue) {
            throw ((ValidationErrorValue)atomicValue).getException();
        }
        return atomicValue;
    }

    public String getStringValue() {
        if ("".equals(this.prefix)) {
            return this.localPart;
        }
        return this.prefix + ':' + this.localPart;
    }

    public String getClarkName() {
        if (this.uri == null) {
            return this.localPart;
        }
        return '{' + this.uri + '}' + this.localPart;
    }

    public String getLocalName() {
        return this.localPart;
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int allocateNameCode(NamePool namePool) {
        return namePool.allocate(this.prefix, this.uri, this.localPart);
    }

    public int hashCode() {
        if (this.uri == null) {
            return this.localPart.hashCode();
        }
        return this.localPart.hashCode() ^ this.uri.hashCode();
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(QualifiedNameValue.class)) {
            return this;
        }
        if (clazz.getName().equals("javax.xml.namespace.QName")) {
            return this.makeQName(xPathContext.getConfiguration());
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of QName to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public String toString() {
        return "QName(\"" + this.uri + "\", \"" + this.localPart + "\")";
    }

    public Object makeQName(Configuration configuration) {
        try {
            Class clazz = configuration.getClass("javax.xml.namespace.QName", false, null);
            Class[] classArray = new Class[]{String.class, String.class, String.class};
            Constructor constructor = clazz.getConstructor(classArray);
            String[] stringArray = new String[]{this.uri, this.localPart, this.prefix};
            Object t = constructor.newInstance(stringArray);
            return t;
        }
        catch (XPathException xPathException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }
}

