/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class Comment
extends SimpleNodeConstructor {
    public int getInstructionNameCode() {
        return 138;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.COMMENT;
    }

    public int getCardinality() {
        return 16384;
    }

    public void localTypeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        String string;
        String string2;
        if (this.select instanceof Literal && !(string2 = this.checkContent(string = ((Literal)this.select).getValue().getStringValue(), staticContext.makeEarlyEvaluationContext())).equals(string)) {
            this.setSelect(new StringLiteral(string2), staticContext.getConfiguration());
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        String string = ((Object)this.expandChildren(xPathContext)).toString();
        string = this.checkContent(string, xPathContext);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        sequenceReceiver.comment(string, this.locationId, 0);
        return null;
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        int n;
        while ((n = string.indexOf("--")) >= 0) {
            if (this.isXSLT()) {
                string = string.substring(0, n + 1) + ' ' + string.substring(n + 1);
                continue;
            }
            DynamicError dynamicError = new DynamicError("Invalid characters (--) in comment", this);
            dynamicError.setErrorCode("XQDY0072");
            dynamicError.setXPathContext(xPathContext);
            throw DynamicError.makeDynamicError(Comment.dynamicError(this, dynamicError, xPathContext));
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '-') {
            if (this.isXSLT()) {
                string = string + ' ';
            } else {
                DynamicError dynamicError = new DynamicError("Comment cannot end in '-'", this);
                dynamicError.setErrorCode("XQDY0072");
                dynamicError.setXPathContext(xPathContext);
                throw DynamicError.makeDynamicError(Comment.dynamicError(this, dynamicError, xPathContext));
            }
        }
        return string;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "comment");
        super.display(n + 1, printStream, configuration);
    }
}

