/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRule;
import org.apache.cocoon.forms.formmodel.CannotYetResolveWarning;
import org.apache.cocoon.forms.validation.ValidationError;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionContext;
import org.outerj.expression.ExpressionException;

public class AssertValidationRule
extends AbstractValidationRule {
    private Expression testExpression;

    public AssertValidationRule(Expression testExpression) {
        this.testExpression = testExpression;
    }

    public ValidationError validate(Object value, ExpressionContext expressionContext) {
        Object expressionResult;
        try {
            expressionResult = this.testExpression.evaluate(expressionContext);
        }
        catch (CannotYetResolveWarning w) {
            return null;
        }
        catch (ExpressionException e) {
            return new ValidationError("Error evaluating expression on assert validation rule.", false);
        }
        if (!(expressionResult instanceof Boolean)) {
            return new ValidationError("Got non-boolean result from expression on assert validation rule.", false);
        }
        if (((Boolean)expressionResult).booleanValue()) {
            return null;
        }
        return this.hasFailMessage() ? this.getFailMessage() : new ValidationError("Assertion validation rule failed.", false);
    }

    public boolean supportsType(Class clazz, boolean arrayType) {
        return true;
    }
}

