/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class SimpleRepeaterJXPathBinding
extends JXPathBindingBase {
    private final String repeaterId;
    private final String repeaterPath;
    private final String rowPath;
    private final boolean clearOnLoad;
    private final JXPathBindingBase rowBinding;
    private final boolean deleteIfEmpty;

    public SimpleRepeaterJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String repeaterId, String repeaterPath, String rowPath, boolean clearOnLoad, boolean deleteIfEmpty, JXPathBindingBase rowBinding) {
        super(commonAtts);
        this.repeaterId = repeaterId;
        this.repeaterPath = repeaterPath;
        this.rowPath = rowPath;
        this.rowBinding = rowBinding;
        this.clearOnLoad = clearOnLoad;
        this.deleteIfEmpty = deleteIfEmpty;
    }

    public void doLoad(Widget frmModel, JXPathContext jctx) throws BindingException {
        Pointer ptr;
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        if (this.clearOnLoad) {
            repeater.removeRows();
        }
        if ((ptr = jctx.getPointer(this.repeaterPath)).getNode() != null) {
            JXPathContext repeaterContext = jctx.getRelativeContext(ptr);
            Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
            int rowNum = 0;
            while (rowPointers.hasNext()) {
                Repeater.RepeaterRow thisRow = repeater.getSize() > rowNum ? repeater.getRow(rowNum) : repeater.addRow();
                ++rowNum;
                Pointer jxp = (Pointer)rowPointers.next();
                JXPathContext rowContext = repeaterContext.getRelativeContext(jxp);
                this.rowBinding.loadFormFromModel((Widget)thisRow, rowContext);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("done loading rows " + this.toString());
        }
    }

    public void doSave(Widget frmModel, JXPathContext jctx) throws BindingException {
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        if (repeater.getSize() == 0 && this.deleteIfEmpty) {
            jctx.removeAll(this.repeaterPath);
        } else {
            JXPathContext repeaterContext = jctx.getRelativeContext(jctx.createPath(this.repeaterPath));
            repeaterContext.removeAll(this.rowPath);
            int i = 0;
            while (i < repeater.getSize()) {
                Pointer rowPtr = repeaterContext.createPath(this.rowPath + '[' + (i + 1) + ']');
                JXPathContext rowContext = repeaterContext.getRelativeContext(rowPtr);
                this.rowBinding.saveFormToModel((Widget)repeater.getRow(i), rowContext);
                ++i;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + " [widget=" + this.repeaterId + ", xpath=" + this.repeaterPath + "]";
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.rowBinding.enableLogging(logger);
    }
}

