/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.mozilla.javascript.Script;

public class JavaScriptJXPathBinding
extends JXPathBindingBase {
    private final String id;
    private final String path;
    private final Script loadScript;
    private final Script saveScript;

    public JavaScriptJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String id, String path, Script loadScript, Script saveScript) {
        super(commonAtts);
        this.id = id;
        this.path = path;
        this.loadScript = loadScript;
        this.saveScript = saveScript;
    }

    public void doLoad(Widget frmModel, JXPathContext jctx) {
        if (this.loadScript != null) {
            Widget widget = this.selectWidget(frmModel, this.id);
            Pointer pointer = jctx.getPointer(this.path);
            Map objectModel = CocoonComponentManager.getCurrentEnvironment().getObjectModel();
            try {
                HashMap<String, Widget> values = new HashMap<String, Widget>(3);
                values.put("widget", widget);
                values.put("jxpathPointer", (Widget)pointer);
                if (pointer.getNode() != null) {
                    values.put("jxpathContext", (Widget)jctx.getRelativeContext(pointer));
                }
                JavaScriptHelper.execScript(this.loadScript, values, objectModel);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Error invoking JavaScript event handler", (Throwable)e);
            }
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("[Javascript Binding] - loadForm: No javascript code avaliable. Widget id=" + this.getId());
        }
    }

    public void doSave(Widget frmModel, JXPathContext jctx) throws BindingException {
        if (this.saveScript != null) {
            Widget widget = this.selectWidget(frmModel, this.id);
            Pointer pointer = jctx.createPath(this.path);
            JXPathContext widgetCtx = jctx.getRelativeContext(pointer);
            try {
                Map objectModel = CocoonComponentManager.getCurrentEnvironment().getObjectModel();
                HashMap<String, Widget> values = new HashMap<String, Widget>();
                values.put("widget", widget);
                values.put("jxpathContext", (Widget)widgetCtx);
                values.put("jxpathPointer", (Widget)pointer);
                JavaScriptHelper.execScript(this.saveScript, values, objectModel);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Error invoking JavaScript event handler", (Throwable)e);
            }
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("[Javascript Binding] - saveForm: No code avaliable on the javascript binding with id \"" + this.getId() + "\"");
        }
    }
}

