/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class Add
extends SvnCommand {
    private File file = null;
    private Vector filesets = new Vector();
    private boolean failonerror = false;
    private File dir = null;
    private boolean recurse = true;
    private boolean force = false;

    public void execute() throws SvnAntException {
        if (this.file != null) {
            this.svnAddFile(this.file);
        }
        if (this.dir != null) {
            this.svnAddDir(this.dir, this.recurse, this.force);
        }
        if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.svnAddFileSet(fileSet);
            }
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new SvnAntValidationException("file, url or fileset must be set");
        }
    }

    private void svnAddFile(File file) throws SvnAntException {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.logWarning("Directory " + file.getAbsolutePath() + " cannot be added using the file attribute.  " + "Use dir instead.");
            } else {
                try {
                    this.svnClient.addFile(file);
                }
                catch (Exception exception) {
                    throw new SvnAntException("Can't add file " + file.getAbsolutePath() + " to repository", exception);
                }
            }
        } else {
            String string = "Warning: Could not find file " + file.getAbsolutePath() + " to add to the repository.";
            if (!this.failonerror) {
                this.logWarning(string);
            } else {
                throw new SvnAntException(string);
            }
        }
    }

    private void svnAddDir(File file, boolean bl, boolean bl2) throws SvnAntException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.logWarning("File " + file.getAbsolutePath() + " cannot be added using the dir attribute.  " + "Use file instead.");
            } else {
                try {
                    this.svnClient.addDirectory(file, bl, bl2);
                }
                catch (Exception exception) {
                    throw new SvnAntException("Can't add directory " + file.getAbsolutePath() + " to repository", exception);
                }
            }
        } else {
            String string = "Warning: Could not find directory " + file.getAbsolutePath() + " to add to the repository.";
            if (!this.failonerror) {
                this.logWarning(string);
            } else {
                throw new SvnAntException(string);
            }
        }
    }

    private void svnAddFileWithDirs(File file, File file2) throws SvnAntException {
        File file3;
        Stack<File> stack = new Stack<File>();
        try {
            if (SVNStatusUtils.isManaged((ISVNStatus)this.svnClient.getSingleStatus(file))) {
                return;
            }
            for (file3 = file.getParentFile(); file3 != null && !SVNStatusUtils.isManaged((ISVNStatus)this.svnClient.getSingleStatus(file3)) && !file3.equals(file2); file3 = file3.getParentFile()) {
                stack.push(file3);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Cannot get status of file or directory", sVNClientException);
        }
        while (stack.size() > 0) {
            file3 = (File)stack.pop();
            try {
                this.svnClient.addFile(file3);
            }
            catch (Exception exception) {
                throw new SvnAntException("Cannot add directory " + file3.getAbsolutePath() + " to repository", exception);
            }
        }
        try {
            this.svnClient.addFile(file);
        }
        catch (Exception exception) {
            throw new SvnAntException("Can't add file " + file.getAbsolutePath() + " to repository", exception);
        }
    }

    private void svnAddFileSet(FileSet fileSet) throws SvnAntException {
        int n;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        for (n = 0; n < stringArray2.length; ++n) {
            this.svnAddFileWithDirs(new File(file, stringArray2[n]), file);
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.svnAddFileWithDirs(new File(file, stringArray[n]), file);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void add(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

