/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.lateral.LateralCache;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.engine.CacheAdaptor;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class LateralCacheNoWait
implements AuxiliaryCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait == null ? (class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait = LateralCacheNoWait.class$("org.apache.jcs.auxiliary.lateral.LateralCacheNoWait")) : class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait));
    private final LateralCache cache;
    private ICacheEventQueue q;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait;

    public LateralCacheNoWait(LateralCache cache) {
        this.cache = cache;
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.q = fact.createCacheEventQueue(new CacheAdaptor(cache), LateralCacheInfo.listenerId, cache.getCacheName(), cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
        if (cache.getStatus() == 3) {
            this.q.destroy();
        }
    }

    public void update(ICacheElement ce) throws IOException {
        try {
            this.q.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public ICacheElement get(Serializable key) {
        if (this.getStatus() != 3) {
            try {
                return this.cache.get(key);
            }
            catch (UnmarshalException ue) {
                log.debug((Object)"Retrying the get owing to UnmarshalException...");
                try {
                    return this.cache.get(key);
                }
                catch (IOException ex) {
                    log.error((Object)"Failed in retrying the get for the second time.");
                    this.q.destroy();
                }
            }
            catch (IOException ex) {
                this.q.destroy();
            }
        }
        return null;
    }

    public Set getGroupKeys(String groupName) {
        return this.cache.getGroupKeys(groupName);
    }

    public boolean remove(Serializable key) {
        try {
            this.q.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
        return false;
    }

    public void removeAll() {
        try {
            this.q.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public void dispose() {
        try {
            this.q.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public int getSize() {
        return this.cache.getSize();
    }

    public int getCacheType() {
        return this.cache.getCacheType();
    }

    public int getStatus() {
        return this.q.isWorking() ? this.cache.getStatus() : 3;
    }

    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(ILateralCacheService lateral) {
        this.cache.fixCache(lateral);
        this.resetEventQ();
    }

    public void resetEventQ() {
        if (this.q.isWorking()) {
            this.q.destroy();
        }
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.q = fact.createCacheEventQueue(new CacheAdaptor(this.cache), LateralCacheInfo.listenerId, this.cache.getCacheName(), this.cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
    }

    public String toString() {
        return "LateralCacheNoWait: " + this.cache.toString();
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        IStats eqStats = this.q.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

