/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.chaperon.build.LexicalAutomatonBuilder;
import net.sourceforge.chaperon.build.ParserAutomatonBuilder;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.grammar.GrammarFactory;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.model.lexicon.LexiconFactory;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.LexicalProcessor;
import net.sourceforge.chaperon.process.ParserAutomaton;
import net.sourceforge.chaperon.process.ParserProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SimpleParser {
    public static void process(File lexiconFile, File grammarFile, File inFile, File outFile) throws Exception {
        String line;
        SimpleLog log = new SimpleLog("log");
        SAXParserFactory parserFactoryImpl = SAXParserFactory.newInstance();
        parserFactoryImpl.setNamespaceAware(true);
        XMLReader xmlparser = parserFactoryImpl.newSAXParser().getXMLReader();
        LexiconFactory lexiconfactory = new LexiconFactory();
        xmlparser.setContentHandler(lexiconfactory);
        xmlparser.parse(lexiconFile.toString());
        Lexicon lexicon = lexiconfactory.getLexicon();
        LexicalAutomaton lexicalautomaton = new LexicalAutomatonBuilder(lexicon, (Log)log).getLexicalAutomaton();
        LexicalProcessor lexer = new LexicalProcessor();
        lexer.setLog((Log)log);
        lexer.setLexicalAutomaton(lexicalautomaton);
        xmlparser = parserFactoryImpl.newSAXParser().getXMLReader();
        GrammarFactory grammarfactory = new GrammarFactory();
        xmlparser.setContentHandler(grammarfactory);
        xmlparser.parse(grammarFile.toString());
        Grammar grammar = grammarfactory.getGrammar();
        ParserAutomaton parserautomaton = new ParserAutomatonBuilder(grammar, (Log)log).getParserAutomaton();
        ParserProcessor parser = new ParserProcessor();
        parser.setLog((Log)log);
        parser.setParserAutomaton(parserautomaton);
        SAXTransformerFactory transformerFactoryImpl = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler serializer = transformerFactoryImpl.newTransformerHandler();
        serializer.setResult(new StreamResult(outFile));
        lexer.setContentHandler(parser);
        parser.setContentHandler(serializer);
        LocatorImpl locator = new LocatorImpl();
        locator.setSystemId(inFile.toURL().toString());
        locator.setLineNumber(1);
        locator.setColumnNumber(1);
        lexer.setDocumentLocator(locator);
        lexer.startDocument();
        lexer.startElement("http://chaperon.sourceforge.net/schema/text/1.0", "text", "text", new AttributesImpl());
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(inFile)));
        String newline = null;
        String separator = System.getProperty("line.separator");
        while ((line = newline == null ? reader.readLine() : newline) != null) {
            newline = reader.readLine();
            line = newline != null ? line + separator : line;
            locator.setLineNumber(reader.getLineNumber());
            locator.setColumnNumber(1);
            lexer.characters(line.toCharArray(), 0, line.length());
            if (newline != null) continue;
        }
        reader.close();
        lexer.endElement("http://chaperon.sourceforge.net/schema/text/1.0", "text", "text");
        lexer.endDocument();
    }

    public static void main(String[] args) {
        File lexiconFile = new File(args[0]);
        File grammarFile = new File(args[1]);
        File inFile = new File(args[2]);
        File outFile = new File(args[3]);
        try {
            SimpleParser.process(lexiconFile, grammarFile, inFile, outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

