/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.transformation.ProxyTransformer;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinkTransformer
extends AbstractTransformer
implements Serviceable {
    public static final String NAMESPACE_PREFIX = "ev";
    protected String copletIdParamString = null;
    protected String portalNameParamString = null;
    protected CopletInstanceData copletInstanceData = null;
    protected String documentBase = null;
    protected Stack elementStack = new Stack();
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.copletInstanceData = ProxyTransformer.getInstanceData(this.manager, objectModel, par);
        this.copletIdParamString = "cocoon-portal-copletid=" + this.copletInstanceData.getId();
        Map context = (Map)objectModel.get("parent-context");
        this.portalNameParamString = "cocoon-portal-portalname=" + (String)context.get("cocoon-portal-portalName");
    }

    public void recycle() {
        this.copletInstanceData = null;
        this.elementStack.clear();
        this.copletIdParamString = null;
        this.portalNameParamString = null;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.documentBase = (String)this.copletInstanceData.getAttribute("documentbase");
        super.startPrefixMapping(NAMESPACE_PREFIX, "http://apache.org/cocoon/portal/eventlink/1.0");
    }

    public void endDocument() throws SAXException {
        super.endPrefixMapping(NAMESPACE_PREFIX);
        super.endDocument();
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if ("form".equalsIgnoreCase(name)) {
            this.handleTag("action", uri, name, raw, attributes, true, attributes.getIndex("target") > -1);
        } else if ("script".equalsIgnoreCase(name)) {
            this.handleTag("src", uri, name, raw, attributes, false, false);
        } else if ("img".equalsIgnoreCase(name)) {
            this.handleTag("src", uri, name, raw, attributes, false, false);
        } else if ("link".equalsIgnoreCase(name)) {
            this.handleTag("href", uri, name, raw, attributes, false, false);
        } else if ("a".equalsIgnoreCase(name)) {
            this.handleTag("href", uri, name, raw, attributes, true, attributes.getIndex("target") > -1);
        } else if ("menu-item".equalsIgnoreCase(name)) {
            this.handleTag("href", uri, name, raw, attributes, true, false);
        } else if ("input".equalsIgnoreCase(name)) {
            this.handleTag("src", uri, name, raw, attributes, false, false);
        } else if ("applet".equalsIgnoreCase(name)) {
            if (attributes.getIndex("codebase") > -1) {
                this.handleTag("codebase", uri, name, raw, attributes, false, true);
            }
        } else {
            super.startElement(uri, name, raw, attributes);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        String elementName = null;
        if (!this.elementStack.empty()) {
            elementName = (String)this.elementStack.peek();
        }
        if (elementName != null && elementName.equals(name)) {
            super.endElement("http://apache.org/cocoon/portal/eventlink/1.0", "eventlink", "ev:eventlink");
        } else {
            super.endElement(uri, name, raw);
        }
    }

    public void handleTag(String attributeName, String uri, String elementName, String raw, Attributes attributes, boolean eventLink, boolean direct) throws SAXException {
        String remoteURI = attributes.getValue(attributeName);
        if (remoteURI == null || remoteURI.startsWith("http://") || remoteURI.startsWith("https://") || remoteURI.startsWith("#") || remoteURI.startsWith("ftp://") || remoteURI.startsWith("javascript:") || remoteURI.startsWith("mailto:")) {
            super.startElement(uri, elementName, raw, attributes);
        } else {
            if (attributes.getIndex("target") > -1 || direct) {
                try {
                    remoteURI = ProxyTransformer.resolveURI(remoteURI, this.documentBase);
                    eventLink = false;
                }
                catch (MalformedURLException ex) {
                    throw new SAXException("Invalid URL encountered: " + remoteURI, ex);
                }
            } else {
                remoteURI = this.buildUrlString(remoteURI, !eventLink);
            }
            Attributes newAttributes = this.modifyLinkAttribute(attributeName, remoteURI, attributes);
            if (eventLink) {
                this.startEventLinkElement(elementName, attributeName, newAttributes);
            } else {
                super.startElement(uri, elementName, raw, newAttributes);
            }
        }
    }

    protected Attributes modifyLinkAttribute(String attribute, String remoteURI, Attributes attributes) {
        AttributesImpl newAttributes = new AttributesImpl(attributes);
        int index = newAttributes.getIndex(attribute);
        newAttributes.setValue(index, remoteURI);
        return newAttributes;
    }

    protected void startEventLinkElement(String element, String attribute, Attributes attributes) throws SAXException {
        this.elementStack.push(element);
        AttributesImpl eventAttributes = null;
        eventAttributes = attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes);
        eventAttributes.addAttribute("", "attribute", "attribute", "CDATA", attribute);
        eventAttributes.addAttribute("", "element", "element", "CDATA", element);
        super.startElement("http://apache.org/cocoon/portal/eventlink/1.0", "eventlink", "ev:eventlink", (Attributes)eventAttributes);
    }

    protected String buildUrlString(String uri, boolean applyPrefixAndPortalParams) {
        StringBuffer uriBuffer = new StringBuffer(uri.length());
        int index_semikolon = uri.indexOf(";");
        int index_question = uri.indexOf("?");
        if (index_semikolon > -1) {
            String sessionToken = uri.substring(index_semikolon + 1, index_question == -1 ? uri.length() : index_question);
            this.copletInstanceData.getPersistentAspectData().put("sessiontoken", sessionToken);
        }
        if (applyPrefixAndPortalParams) {
            uriBuffer.append("proxy-");
        }
        uriBuffer.append(uri);
        if (applyPrefixAndPortalParams) {
            uriBuffer.append(index_question == -1 ? (char)'?' : '&');
            uriBuffer.append(this.copletIdParamString);
            uriBuffer.append('&');
            uriBuffer.append(this.portalNameParamString);
        }
        return uriBuffer.toString();
    }
}

