/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.variables.VariableResolver;
import org.apache.cocoon.components.variables.VariableResolverFactory;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.AbstractAspect;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLTAspect
extends AbstractAspect
implements Disposable {
    protected List variables = new ArrayList();
    protected VariableResolverFactory variableFactory;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.variableFactory = (VariableResolverFactory)this.manager.lookup(VariableResolverFactory.ROLE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        XSLTProcessor processor;
        block10: {
            PreparedConfiguration config = (PreparedConfiguration)context.getAspectConfiguration();
            processor = null;
            Source stylesheet = null;
            SourceResolver resolver = null;
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                stylesheet = resolver.resolveURI(this.getStylesheetURI(config, layout));
                processor = (XSLTProcessor)this.manager.lookup(config.xsltRole);
                TransformerHandler transformer = processor.getTransformerHandler(stylesheet);
                Map parameter = layout.getParameters();
                if (parameter.size() > 0) {
                    Transformer theTransformer = transformer.getTransformer();
                    Iterator iter = parameter.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        theTransformer.setParameter((String)entry.getKey(), entry.getValue());
                    }
                }
                SAXResult result = new SAXResult((ContentHandler)new IncludeXMLConsumer(handler));
                if (handler instanceof LexicalHandler) {
                    result.setLexicalHandler((LexicalHandler)((Object)handler));
                }
                transformer.setResult(result);
                transformer.startDocument();
                context.invokeNext(layout, service, transformer);
                transformer.endDocument();
                if (null == resolver) break block10;
            }
            catch (XSLTProcessorException xpe) {
                try {
                    throw new SAXException("XSLT Exception.", (Exception)((Object)xpe));
                    catch (IOException io) {
                        throw new SAXException("Error in resolving.", io);
                    }
                    catch (ServiceException ce) {
                        throw new SAXException("Unable to lookup component.", (Exception)((Object)ce));
                    }
                }
                catch (Throwable throwable) {
                    if (null != resolver) {
                        resolver.release(stylesheet);
                        this.manager.release((Object)resolver);
                    }
                    this.manager.release(processor);
                    throw throwable;
                }
            }
            resolver.release(stylesheet);
            this.manager.release((Object)resolver);
        }
        this.manager.release((Object)processor);
    }

    protected String getStylesheetURI(PreparedConfiguration config, Layout layout) throws SAXException {
        try {
            String stylesheet = config.stylesheet.resolve();
            return stylesheet;
        }
        catch (PatternException pe) {
            throw new SAXException("Pattern exception during variable resolving.", (Exception)((Object)pe));
        }
    }

    public Object prepareConfiguration(Parameters configuration) throws ParameterException {
        PreparedConfiguration pc = new PreparedConfiguration();
        pc.xsltRole = configuration.getParameter("xslt-processor-role", XSLTProcessor.ROLE);
        String stylesheet = configuration.getParameter("style");
        try {
            pc.stylesheet = this.variableFactory.lookup(stylesheet);
        }
        catch (PatternException pe) {
            throw new ParameterException("Unknown pattern for stylesheet " + stylesheet, (Throwable)pe);
        }
        this.variables.add(pc.stylesheet);
        return pc;
    }

    public void dispose() {
        if (this.manager != null) {
            Iterator vars = this.variables.iterator();
            while (vars.hasNext()) {
                this.variableFactory.release((VariableResolver)vars.next());
            }
            this.variables.clear();
            this.manager.release((Object)this.variableFactory);
            this.manager = null;
            this.variableFactory = null;
        }
    }

    protected class PreparedConfiguration {
        public VariableResolver stylesheet;
        public String xsltRole;

        protected PreparedConfiguration() {
        }

        public void takeValues(PreparedConfiguration from) {
            this.stylesheet = from.stylesheet;
            this.xsltRole = from.xsltRole;
        }
    }
}

