/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.impl;

import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.portal.PortalManager;
import org.apache.cocoon.portal.event.Event;
import org.apache.cocoon.portal.event.EventManager;
import org.apache.cocoon.portal.event.Filter;
import org.apache.cocoon.portal.event.Subscriber;
import org.apache.cocoon.portal.impl.PortalManagerImpl;
import org.apache.cocoon.portal.pluto.PortletContainerEnvironmentImpl;
import org.apache.cocoon.portal.pluto.PortletURLProviderImpl;
import org.apache.cocoon.portal.pluto.servlet.ServletRequestImpl;
import org.apache.cocoon.portal.pluto.servlet.ServletResponseImpl;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletContainerImpl;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.PortletContainerEnvironment;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderService;
import org.apache.pluto.services.information.PortletActionProvider;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PortletPortalManager
extends PortalManagerImpl
implements Initializable,
Contextualizable,
Disposable,
Subscriber {
    public static ThreadLocal copletInstanceData = new InheritableThreadLocal();
    protected ServletConfig servletConfig;
    protected PortletContainer portletContainer;
    protected PortletContainerEnvironmentImpl portletContainerEnvironment;
    protected Context context;
    static /* synthetic */ Class class$org$apache$cocoon$portal$pluto$PortletURLProviderImpl;
    static /* synthetic */ Class class$org$apache$pluto$services$information$InformationProviderService;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
        try {
            this.servletConfig = (ServletConfig)context.get((Object)"servlet-config");
            this.servletConfig.getServletContext().setAttribute(PortalManager.ROLE, (Object)this);
        }
        catch (ContextException ignore) {
            this.getLogger().warn("The JSR-168 support is disabled as the servlet context is not available.", (Throwable)ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        EventManager eventManager = null;
        try {
            eventManager = (EventManager)this.manager.lookup(EventManager.ROLE);
            eventManager.getRegister().subscribe(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.manager.release((Object)eventManager);
            throw throwable;
        }
        this.manager.release((Object)eventManager);
    }

    public void dispose() {
        try {
            if (this.portletContainer != null) {
                this.portletContainer.shutdown();
                this.portletContainer = null;
            }
            ContainerUtil.dispose((Object)((Object)this.portletContainerEnvironment));
            this.portletContainerEnvironment = null;
        }
        catch (Throwable t) {
            this.getLogger().error("Destruction failed!", t);
        }
        if (this.servletConfig != null) {
            this.servletConfig.getServletContext().removeAttribute(PortalManager.ROLE);
            this.servletConfig = null;
        }
    }

    public void initialize() throws Exception {
        if (this.servletConfig != null) {
            this.initContainer();
        }
    }

    public PortletContainer getPortletContainer() {
        return this.portletContainer;
    }

    public PortletContainerEnvironment getPortletContainerEnvironment() {
        return this.portletContainerEnvironment;
    }

    public void initContainer() throws Exception {
        this.portletContainer = new PortletContainerImpl();
        if (!this.portletContainer.isInitialized()) {
            this.getLogger().debug("Initializing PortletContainer...");
            String uniqueContainerName = "cocoon-portal";
            this.portletContainerEnvironment = new PortletContainerEnvironmentImpl();
            ContainerUtil.enableLogging((Object)((Object)this.portletContainerEnvironment), (Logger)this.getLogger());
            ContainerUtil.contextualize((Object)((Object)this.portletContainerEnvironment), (Context)this.context);
            ContainerUtil.service((Object)((Object)this.portletContainerEnvironment), (ServiceManager)this.manager);
            ContainerUtil.initialize((Object)((Object)this.portletContainerEnvironment));
            Properties properties = new Properties();
            try {
                this.portletContainer.init("cocoon-portal", this.servletConfig, (PortletContainerEnvironment)this.portletContainerEnvironment, properties);
            }
            catch (PortletContainerException exc) {
                throw new ProcessingException("Initialization of the portlet container failed.", (Throwable)exc);
            }
        } else {
            this.getLogger().debug("PortletContainer already initialized.");
        }
        this.getLogger().debug("PortletContainer initialized.");
    }

    public void process() throws ProcessingException {
        super.process();
        if (this.servletConfig == null) {
            return;
        }
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        PortletURLProviderImpl event = (PortletURLProviderImpl)objectModel.get("portlet-event");
        if (event != null) {
            PortletWindow actionWindow = event.getPortletWindow();
            try {
                ServletRequestImpl req = (ServletRequestImpl)objectModel.get("portlet-request");
                ServletResponseImpl res = (ServletResponseImpl)objectModel.get("portlet-response");
                this.portletContainer.processPortletAction(actionWindow, (HttpServletRequest)req.getRequest(actionWindow), (HttpServletResponse)res);
                String redirectURL = res.getRedirectURL();
                HttpServletResponse response = (HttpServletResponse)objectModel.get("httpresponse");
                response.sendRedirect(redirectURL);
            }
            catch (Exception ignore) {
                this.getLogger().error("Error during processing of portlet action.", (Throwable)ignore);
            }
        } else if (objectModel.get("portlet-response") == null) {
            HttpServletResponse res = (HttpServletResponse)objectModel.get("httpresponse");
            objectModel.put("portlet-response", new ServletResponseImpl(res));
            ServletRequestImpl req = new ServletRequestImpl((HttpServletRequest)objectModel.get("httprequest"), null);
            objectModel.put("portlet-request", req);
        }
    }

    public void showPortal(ContentHandler contentHandler, Parameters parameters) throws SAXException {
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        if (objectModel.get("portlet-event") == null) {
            super.showPortal(contentHandler, parameters);
        }
    }

    public Class getEventType() {
        return class$org$apache$cocoon$portal$pluto$PortletURLProviderImpl == null ? (class$org$apache$cocoon$portal$pluto$PortletURLProviderImpl = PortletPortalManager.class$("org.apache.cocoon.portal.pluto.PortletURLProviderImpl")) : class$org$apache$cocoon$portal$pluto$PortletURLProviderImpl;
    }

    public Filter getFilter() {
        return null;
    }

    public void inform(Event e) {
        PortletURLProviderImpl event = (PortletURLProviderImpl)e;
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        ServletRequestImpl req = new ServletRequestImpl((HttpServletRequest)objectModel.get("httprequest"), event);
        ServletResponseImpl res = new ServletResponseImpl((HttpServletResponse)objectModel.get("httpresponse"));
        objectModel.put("portlet-response", res);
        objectModel.put("portlet-request", req);
        if (event.isAction()) {
            objectModel.put("portlet-event", event);
        } else {
            WindowState state;
            InformationProviderService ips = (InformationProviderService)this.portletContainerEnvironment.getContainerService(class$org$apache$pluto$services$information$InformationProviderService == null ? (class$org$apache$pluto$services$information$InformationProviderService = PortletPortalManager.class$("org.apache.pluto.services.information.InformationProviderService")) : class$org$apache$pluto$services$information$InformationProviderService);
            DynamicInformationProvider dynProv = ips.getDynamicProvider((HttpServletRequest)req);
            PortletActionProvider pap = dynProv.getPortletActionProvider(event.getPortletWindow());
            PortletMode mode = event.getPortletMode();
            if (mode != null) {
                pap.changePortletMode(mode);
            }
            if ((state = event.getWindowState()) != null) {
                pap.changePortletWindowState(state);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

