/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.event.aspect.impl;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.event.Event;
import org.apache.cocoon.portal.event.Publisher;
import org.apache.cocoon.portal.event.aspect.EventAspect;
import org.apache.cocoon.portal.event.aspect.EventAspectContext;

public class RequestParameterEventAspect
extends AbstractLogEnabled
implements EventAspect,
ThreadSafe {
    protected void process(EventAspectContext context, Request request, String parameterName) {
        String[] values = request.getParameterValues(parameterName);
        if (values != null) {
            Publisher publisher = context.getEventPublisher();
            int i = 0;
            while (i < values.length) {
                String current = values[i];
                Event e = context.getEventConverter().decode(current);
                if (null != e) {
                    publisher.publish(e);
                }
                ++i;
            }
        }
    }

    public void process(EventAspectContext context, PortalService service) {
        Request request = ObjectModelHelper.getRequest((Map)context.getObjectModel());
        Parameters config = context.getAspectParameters();
        String requestParameterNames = config.getParameter("parameter-name", "cocoon-portal-event");
        boolean processedDefault = false;
        StringTokenizer tokenizer = new StringTokenizer(requestParameterNames, ", ");
        while (tokenizer.hasMoreTokens()) {
            String currentName = tokenizer.nextToken();
            this.process(context, request, currentName);
            if (!"cocoon-portal-event".equals(currentName)) continue;
            processedDefault = true;
        }
        if (!processedDefault) {
            this.process(context, request, "cocoon-portal-event");
        }
        context.invokeNext(service);
    }
}

