/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceFactory;
import org.apache.cocoon.components.source.SourceHandler;
import org.apache.cocoon.components.source.URLSource;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.util.ClassUtils;

public final class SourceHandlerImpl
extends AbstractLogEnabled
implements Configurable,
Disposable,
Composable,
Contextualizable,
SourceHandler {
    private ComponentManager manager;
    private URLFactory urlFactory;
    private Map sourceFactories;
    private Context context;

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Getting the SourceFactories");
            }
            HashMap<String, SourceFactory> factories = new HashMap<String, SourceFactory>();
            Configuration[] configs = conf.getChildren("protocol");
            SourceFactory sourceFactory = null;
            String protocol = null;
            for (int i = 0; i < configs.length; ++i) {
                protocol = configs[i].getAttribute("name");
                if (factories.containsKey(protocol)) {
                    throw new ConfigurationException("SourceFactory defined twice for protocol: " + protocol);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\tfor protocol: " + protocol + " " + configs[i].getAttribute("class"));
                }
                sourceFactory = (SourceFactory)ClassUtils.newInstance((String)configs[i].getAttribute("class"));
                this.init(sourceFactory, configs[i]);
                factories.put(protocol, sourceFactory);
            }
            this.sourceFactories = Collections.synchronizedMap(factories);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not get parameters because: " + e.getMessage());
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.urlFactory = (URLFactory)this.manager.lookup("org.apache.cocoon.components.url.URLFactory");
    }

    public void dispose() {
        this.manager.release((Component)this.urlFactory);
        Iterator iter = this.sourceFactories.values().iterator();
        while (iter.hasNext()) {
            SourceFactory current = (SourceFactory)iter.next();
            this.deinit(current);
        }
        this.sourceFactories = null;
    }

    public Source getSource(Environment environment, String location) throws ProcessingException, MalformedURLException, IOException {
        String protocol;
        SourceFactory sourceFactory;
        int protocolEnd = location.indexOf(58);
        if (protocolEnd != -1 && (sourceFactory = (SourceFactory)this.sourceFactories.get(protocol = location.substring(0, protocolEnd))) != null) {
            return sourceFactory.getSource(environment, location);
        }
        URLSource result = new URLSource(this.urlFactory.getURL(location), this.manager);
        if (result instanceof LogEnabled) {
            ((LogEnabled)result).enableLogging(this.getLogger());
        }
        return result;
    }

    public Source getSource(Environment environment, URL base, String location) throws ProcessingException, MalformedURLException, IOException {
        String protocol = base.getProtocol();
        SourceFactory sourceFactory = (SourceFactory)this.sourceFactories.get(protocol);
        if (sourceFactory != null) {
            return sourceFactory.getSource(environment, base, location);
        }
        return new URLSource(this.urlFactory.getURL(base, location), this.manager);
    }

    public void addFactory(String protocol, SourceFactory factory) throws ProcessingException {
        try {
            this.init(factory, null);
            SourceFactory oldFactory = this.sourceFactories.put(protocol, factory);
            if (oldFactory != null) {
                this.deinit(oldFactory);
            }
        }
        catch (ComponentException e) {
            throw new ProcessingException("cannot initialize factory: " + factory, (Throwable)e);
        }
        catch (ContextException e) {
            throw new ProcessingException("cannot initialize factory: " + factory, (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException("cannot configure factory: " + factory, (Throwable)e);
        }
    }

    private void init(SourceFactory factory, Configuration config) throws ContextException, ComponentException, ConfigurationException {
        if (factory instanceof LogEnabled) {
            ((LogEnabled)factory).enableLogging(this.getLogger());
        }
        if (factory instanceof Contextualizable) {
            ((Contextualizable)factory).contextualize(this.context);
        }
        if (factory instanceof Composable) {
            ((Composable)factory).compose(this.manager);
        }
        if (config != null && factory instanceof Configurable) {
            ((Configurable)factory).configure(config);
        }
    }

    private void deinit(SourceFactory factory) {
        if (factory instanceof Disposable) {
            ((Disposable)factory).dispose();
        }
    }
}

