/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.Serializable;
import java.util.Stack;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;

public class WMFPainter {
    private static final String WMF_FILE_EXTENSION = ".wmf";
    private static final int INPUT_BUFFER_SIZE = 30720;
    private static BasicStroke solid = new BasicStroke(1.0f, 0, 1);
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    private WMFRecordStore currentStore;
    private transient boolean bReadingWMF = true;
    private transient BufferedInputStream bufStream = null;

    public WMFPainter(WMFRecordStore wMFRecordStore) {
        this.setRecordStore(wMFRecordStore);
    }

    public void paint(Graphics graphics) {
        int n = 10;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        Font font = null;
        Stack<Serializable> stack = new Stack<Serializable>();
        int n8 = this.currentStore.getNumRecords();
        int n9 = this.currentStore.getNumObjects();
        int n10 = this.currentStore.getVpX();
        int n11 = this.currentStore.getVpY();
        int n12 = this.currentStore.getVpW();
        int n13 = this.currentStore.getVpH();
        if (!this.currentStore.isReading()) {
            GdiObject gdiObject;
            int n14;
            graphics.setPaintMode();
            n5 = -1;
            n6 = -1;
            n7 = -1;
            Color color = null;
            Color color2 = null;
            for (n14 = 0; n14 < n9; ++n14) {
                gdiObject = this.currentStore.getObject(n14);
                gdiObject.Clear();
            }
            n14 = n12;
            int n15 = n13;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n14, n15);
            graphics.setColor(Color.black);
            double d = (double)n14 / (double)n12;
            double d2 = (double)n15 / (double)n13;
            block51: for (int i = 0; i < n8; ++i) {
                MetaRecord metaRecord = this.currentStore.getRecord(i);
                switch (metaRecord.functionId) {
                    case 523: {
                        n10 = -metaRecord.ElementAt(0).intValue();
                        this.currentStore.setVpX(n10);
                        n11 = -metaRecord.ElementAt(1).intValue();
                        this.currentStore.setVpY(n11);
                        continue block51;
                    }
                    case 0: 
                    case 524: {
                        n12 = metaRecord.ElementAt(0);
                        this.currentStore.setVpW(n12);
                        n13 = metaRecord.ElementAt(1);
                        this.currentStore.setVpH(n13);
                        d = (double)n14 / (double)n12;
                        d2 = (double)n15 / (double)n13;
                        continue block51;
                    }
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 1040: 
                    case 1042: {
                        continue block51;
                    }
                    case 262: {
                        continue block51;
                    }
                    case 762: {
                        Color color3;
                        int n16 = 0;
                        try {
                            n16 = metaRecord.ElementAt(5);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n17 = metaRecord.ElementAt(0);
                        if (n17 == 5) {
                            color3 = new Color(255, 255, 255);
                            n16 = n9 + 8;
                            this.addObjectAt(this.currentStore, 4, color3, n16);
                        } else {
                            color3 = new Color(metaRecord.ElementAt(1), metaRecord.ElementAt(2), metaRecord.ElementAt(3));
                            this.addObjectAt(this.currentStore, 1, color3, n16);
                        }
                        n2 = metaRecord.ElementAt(4);
                        continue block51;
                    }
                    case 764: {
                        int n18 = 0;
                        try {
                            n18 = metaRecord.ElementAt(5);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n19 = metaRecord.ElementAt(0);
                        if (n19 == 0) {
                            this.addObjectAt(this.currentStore, 2, new Color(metaRecord.ElementAt(1), metaRecord.ElementAt(2), metaRecord.ElementAt(3)), n18);
                            continue block51;
                        }
                        this.addObjectAt(this.currentStore, 5, new Color(0, 0, 0), n18);
                        continue block51;
                    }
                    case 763: {
                        int n20 = metaRecord.ElementAt(1) > 0 ? 2 : 0;
                        n20 |= metaRecord.ElementAt(2) > 400 ? 1 : 0;
                        int n21 = (int)(d2 * (double)metaRecord.ElementAt(0).intValue());
                        String string = ((StringRecord)metaRecord).text;
                        if (n21 < 0) {
                            n21 = (int)((double)n21 * -1.3);
                        }
                        int n22 = 0;
                        try {
                            n22 = metaRecord.ElementAt(3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        n = n21;
                        font = new Font(string, n20, n21);
                        this.addObjectAt(this.currentStore, 3, font, n22);
                        continue block51;
                    }
                    case 247: 
                    case 248: 
                    case 322: 
                    case 505: 
                    case 765: 
                    case 1790: 
                    case 1791: {
                        this.addObjectAt(this.currentStore, 6, new Integer(0), 0);
                        continue block51;
                    }
                    case 53: 
                    case 55: 
                    case 313: 
                    case 564: 
                    case 1078: {
                        continue block51;
                    }
                    case 301: {
                        int n23 = metaRecord.ElementAt(0);
                        if ((n23 & Integer.MIN_VALUE) != 0) continue block51;
                        if (n23 >= n9) {
                            switch (n23 -= n9) {
                                case 5: {
                                    n5 = -1;
                                    continue block51;
                                }
                                case 8: {
                                    n6 = -1;
                                    continue block51;
                                }
                            }
                            continue block51;
                        }
                        gdiObject = this.currentStore.getObject(n23);
                        if (!gdiObject.used) continue block51;
                        switch (gdiObject.type) {
                            case 1: {
                                graphics.setColor((Color)gdiObject.obj);
                                n6 = n23;
                                break;
                            }
                            case 2: {
                                graphics.setColor((Color)gdiObject.obj);
                                n5 = n23;
                                break;
                            }
                            case 3: {
                                font = (Font)gdiObject.obj;
                                graphics.setFont(font);
                                n7 = n23;
                                break;
                            }
                            case 4: {
                                n6 = -1;
                                break;
                            }
                            case 5: {
                                n5 = -1;
                            }
                        }
                        continue block51;
                    }
                    case 496: {
                        int n23 = metaRecord.ElementAt(0);
                        gdiObject = this.currentStore.getObject(n23);
                        if (n23 == n5) {
                            n5 = -1;
                        } else if (n23 == n6) {
                            n6 = -1;
                        } else if (n23 == n7) {
                            n7 = -1;
                        }
                        gdiObject.Clear();
                        continue block51;
                    }
                    case 1336: {
                        int n24;
                        int n25 = metaRecord.ElementAt(0);
                        int[] nArray = new int[n25];
                        for (n24 = 0; n24 < n25; ++n24) {
                            nArray[n24] = metaRecord.ElementAt(n24 + 1);
                        }
                        n24 = n25 + 1;
                        for (int j = 0; j < n25; ++j) {
                            int n26 = nArray[j];
                            int[] nArray2 = new int[n26];
                            int[] nArray3 = new int[n26];
                            for (int k = 0; k < n26; ++k) {
                                nArray2[k] = (int)(d * (double)(n10 + metaRecord.ElementAt(n24 + k * 2)));
                                nArray3[k] = (int)(d2 * (double)(n11 + metaRecord.ElementAt(n24 + k * 2 + 1)));
                            }
                            n24 += n26;
                            if (n5 >= 0) {
                                this.setBrushColor(this.currentStore, graphics, n5);
                                graphics.fillPolygon(nArray2, nArray3, n26);
                            }
                            this.setPenColor(this.currentStore, graphics, n6);
                            graphics.drawPolygon(nArray2, nArray3, n26);
                        }
                        continue block51;
                    }
                    case 804: {
                        int n27 = metaRecord.ElementAt(0);
                        int[] nArray = new int[n27 + 1];
                        int[] nArray4 = new int[n27 + 1];
                        for (int j = 0; j < n27; ++j) {
                            nArray[j] = (int)(d * (double)(n10 + metaRecord.ElementAt(j * 2 + 1)));
                            nArray4[j] = (int)(d2 * (double)(n11 + metaRecord.ElementAt(j * 2 + 2)));
                        }
                        nArray[n27] = nArray[0];
                        nArray4[n27] = nArray4[0];
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillPolygon(nArray, nArray4, n27);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawPolygon(nArray, nArray4, n27 + 1);
                        continue block51;
                    }
                    case 532: {
                        n3 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        n4 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        continue block51;
                    }
                    case 531: {
                        int n28 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n29 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawLine(n3, n4, n28, n29);
                        n3 = n28;
                        n4 = n29;
                        continue block51;
                    }
                    case 805: {
                        this.setPenColor(this.currentStore, graphics, n6);
                        int n30 = metaRecord.ElementAt(0);
                        int n31 = (int)(d * (double)(n10 + metaRecord.ElementAt(1)));
                        int n32 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(2)));
                        for (int j = 1; j < n30; ++j) {
                            int n33 = (int)(d * (double)(n10 + metaRecord.ElementAt(j * 2 + 1)));
                            int n34 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(j * 2 + 2)));
                            graphics.drawLine(n31, n32, n33, n34);
                            n31 = n33;
                            n32 = n34;
                        }
                        continue block51;
                    }
                    case 1051: {
                        int n35 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n36 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n37 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n38 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillRect(n35, n37, n36 - n35 - 1, n38 - n37 - 1);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawRect(n35, n37, n36 - n35 - 1, n38 - n37 - 1);
                        continue block51;
                    }
                    case 1564: {
                        int n39 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n40 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n41 = (int)(d * (double)metaRecord.ElementAt(4).intValue());
                        int n42 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n43 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        int n44 = (int)(d2 * (double)metaRecord.ElementAt(5).intValue());
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillRoundRect(n39, n42, n40 - n39, n43 - n42, n41, n44);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawRoundRect(n39, n42, n40 - n39, n43 - n42, n41, n44);
                        continue block51;
                    }
                    case 1048: {
                        int n45 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n46 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n47 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n48 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        if (n5 >= 0) {
                            this.setBrushColor(this.currentStore, graphics, n5);
                            graphics.fillOval(n45, n47, n46 - n45, n48 - n47);
                        }
                        this.setPenColor(this.currentStore, graphics, n6);
                        graphics.drawOval(n45, n47, n46 - n45 - 1, n48 - n47 - 1);
                        continue block51;
                    }
                    case 521: {
                        color = new Color(metaRecord.ElementAt(0), metaRecord.ElementAt(1), metaRecord.ElementAt(2));
                        continue block51;
                    }
                    case 513: {
                        color2 = new Color(metaRecord.ElementAt(0), metaRecord.ElementAt(1), metaRecord.ElementAt(2));
                        continue block51;
                    }
                    case 1313: 
                    case 1583: 
                    case 2610: {
                        Shape shape;
                        float f;
                        try {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            int n49 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                            int n50 = (int)((double)n + d2 * (double)(n11 + metaRecord.ElementAt(1)));
                            if (color != null) {
                                graphics.setColor(color);
                            } else {
                                graphics.setColor(Color.black);
                            }
                            StringRecord stringRecord = (StringRecord)metaRecord;
                            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                            GeneralPath generalPath = new GeneralPath(1);
                            TextLayout textLayout = new TextLayout(stringRecord.text, font, fontRenderContext);
                            double_.y += (double)textLayout.getAscent();
                            if (bl || stringRecord.text.startsWith("Sono una scala verticale di prevalenza")) {
                                AffineTransform affineTransform = new AffineTransform();
                                f = (float)textLayout.getBounds().getHeight();
                                AffineTransform affineTransform2 = new AffineTransform();
                                affineTransform2.translate(n49, n50);
                                affineTransform2.rotate(Math.toRadians(270.0));
                                affineTransform2.translate(0.0, f);
                                shape = textLayout.getOutline(affineTransform2);
                                generalPath.append(affineTransform.createTransformedShape(shape), false);
                                graphics2D.draw(shape);
                                continue block51;
                            }
                            graphics.drawString(stringRecord.text, n49, n50);
                        }
                        catch (Exception exception) {}
                        continue block51;
                    }
                    case 2071: 
                    case 2074: {
                        int n51 = (int)(d * (double)(n10 + metaRecord.ElementAt(0)));
                        int n52 = (int)(d * (double)(n10 + metaRecord.ElementAt(2)));
                        int n53 = (int)(d * (double)metaRecord.ElementAt(4).intValue());
                        int n54 = (int)(d * (double)metaRecord.ElementAt(6).intValue());
                        int n55 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(1)));
                        int n56 = (int)(d2 * (double)(n11 + metaRecord.ElementAt(3)));
                        int n57 = (int)(d2 * (double)metaRecord.ElementAt(5).intValue());
                        int n58 = (int)(d2 * (double)metaRecord.ElementAt(7).intValue());
                        this.setBrushColor(this.currentStore, graphics, n5);
                        int n59 = n51 + (n52 - n51) / 2;
                        int n60 = n55 + (n56 - n55) / 2;
                        int n61 = (int)Math.atan((n57 - n60) / (n53 - n59));
                        int n62 = (int)Math.atan((n58 - n60) / (n54 - n59));
                        if (metaRecord.functionId == 2071) {
                            graphics.drawArc(n51, n55, n52 - n51, n56 - n55, n61, n62);
                            continue block51;
                        }
                        graphics.fillArc(n51, n55, n52 - n51, n56 - n55, n61, n62);
                        continue block51;
                    }
                    case 2096: {
                        continue block51;
                    }
                    case 30: {
                        stack.push(new Integer(n2));
                        stack.push(new Integer(n3));
                        stack.push(new Integer(n4));
                        stack.push(new Integer(n5));
                        stack.push(new Integer(n6));
                        stack.push(new Integer(n7));
                        stack.push(color);
                        stack.push(color2);
                        continue block51;
                    }
                    case 295: {
                        color2 = (Color)stack.pop();
                        color = (Color)stack.pop();
                        n7 = (Integer)stack.pop();
                        n6 = (Integer)stack.pop();
                        n5 = (Integer)stack.pop();
                        n4 = (Integer)stack.pop();
                        n3 = (Integer)stack.pop();
                        n2 = (Integer)stack.pop();
                        continue block51;
                    }
                    case 4096: {
                        Shape shape;
                        float f;
                        try {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            this.setPenColor(this.currentStore, graphics, n6);
                            int n63 = metaRecord.ElementAt(0);
                            int n64 = (n63 - 1) / 3;
                            f = (float)(d * (double)(n10 + metaRecord.ElementAt(1)));
                            float f2 = (float)(d2 * (double)(n11 + metaRecord.ElementAt(2)));
                            shape = new GeneralPath(1);
                            ((Path2D.Float)shape).moveTo(f, f2);
                            for (int j = 0; j < n64; ++j) {
                                float f3 = (float)(d * (double)(n10 + metaRecord.ElementAt(j * 6 + 3)));
                                float f4 = (float)(d2 * (double)(n11 + metaRecord.ElementAt(j * 6 + 4)));
                                float f5 = (float)(d * (double)(n10 + metaRecord.ElementAt(j * 6 + 5)));
                                float f6 = (float)(d2 * (double)(n11 + metaRecord.ElementAt(j * 6 + 6)));
                                float f7 = (float)(d * (double)(n10 + metaRecord.ElementAt(j * 6 + 7)));
                                float f8 = (float)(d2 * (double)(n11 + metaRecord.ElementAt(j * 6 + 8)));
                                ((Path2D.Float)shape).curveTo(f3, f4, f5, f6, f7, f8);
                                f = f7;
                                f2 = f8;
                            }
                            graphics2D.setStroke(solid);
                            graphics2D.draw(shape);
                        }
                        catch (Exception exception) {
                            System.out.println("Unable to draw static text as a 2D graphics context is required");
                        }
                        continue block51;
                    }
                }
            }
        }
    }

    private void setPenColor(WMFRecordStore wMFRecordStore, Graphics graphics, int n) {
        if (n >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n);
            graphics.setColor((Color)gdiObject.obj);
            n = -1;
        }
    }

    private void setBrushColor(WMFRecordStore wMFRecordStore, Graphics graphics, int n) {
        if (n >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n);
            graphics.setColor((Color)gdiObject.obj);
            n = -1;
        }
    }

    public void setRecordStore(WMFRecordStore wMFRecordStore) {
        if (wMFRecordStore == null) {
            throw new IllegalArgumentException();
        }
        this.currentStore = wMFRecordStore;
    }

    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }

    private void addObject(WMFRecordStore wMFRecordStore, int n, Object object) {
        wMFRecordStore.addObject(n, object);
    }

    private void addObjectAt(WMFRecordStore wMFRecordStore, int n, Object object, int n2) {
        wMFRecordStore.addObjectAt(n, object, n2);
    }
}

