/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
 */
package fr.gouv.culture.sdx.utils.xml;

public class Utils {
	
	/**	Parses a text and escapes '&lt;', '&amp;' chars with corresponding
     * entities.
	 * 
	 * @param content	The String to work
	 * @return	
	 */
	public static String escapeXMLCharacters(String content){
		String ret = content;
		if ( content!=null && !content.equals("") )
		{
			char[] cs = content.toCharArray();
			StringBuffer sb = new StringBuffer(content.length());
			for (int i=0; i<cs.length; i++) {
				switch (cs[i]) {
					case '<':
						sb.append("&lt;");
						break;
					case '&':
						sb.append("&amp;");
						break;
					default:
						sb.append(cs[i]);
						break;
				}
				
			}
			ret = sb.toString();
		}
		return ret;
	}
	
	/**	Parses a text and escapes '&lt;', '&amp;', '&lt;', '&amp;' chars with corresponding
     * entities.
	 * 
	 * @param content	The String to work
	 * @return	
	 */
	public static String escapeXMLEntities(String content){
		String ret = content;
		if ( content!=null && content.equals("") )
		{
			char[] cs = content.toCharArray();
			StringBuffer sb = new StringBuffer(content.length());
			for (int i=0; i<cs.length; i++) {
				switch (cs[i]) {
					case '<':
						sb.append("&lt;");
						break;
					case '&':
						sb.append("&amp;");
						break;
					case '>':
						sb.append("&gt;");
						break;
					case '"':
						sb.append("&quot;");
						break;
					default:
						sb.append(cs[i]);
						break;
				}
				
			}
			ret = sb.toString();
		}
		return ret;
	}

}
