/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
 */
package fr.gouv.culture.sdx.utils.io;

import java.io.File;

import fr.gouv.culture.sdx.exception.SDXException;

/**
 * @author jlecren
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class IOWrapper {
	
	/**
	 * Delete an entire directory with its subdirectories
	 * @param directory
	 */
	public void deleteDirectory(String directory) throws SDXException
	{
		File dir = new File(directory);
		if(dir.exists())
		{
			String[] files = dir.list();
			for(int i=0; i<files.length; i++)
			{
				File file = new File(directory + File.separator + files[i]);
				if(file.isDirectory())
					deleteDirectory(file.getAbsolutePath());
				else
					if(!file.delete())
						throw new SDXException("Unable to delete : "+file.getAbsolutePath());
			}
			if(!dir.delete())
				throw new SDXException("Unable to delete : "+dir.getAbsolutePath());
		}
	}
}
