/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/

package fr.gouv.culture.sdx.search.lucene.queryparser;

import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import org.apache.lucene.search.Query;

/**
 * Constructs QueryParser
 *
 */
public interface QueryParser extends fr.gouv.culture.sdx.search.QueryParser {

    public static final int DEFAULT_OPERATOR = QueryParser.OPERATOR_OR;
    public static final int OPERATOR_OR = 0;
    public static final int OPERATOR_AND = 1;
    public static final int DEFAULT_PHRASE_SLOP = 0;

    /**Sets the fields of the query parser
     *  @param f	the default field for query terms.
     *  @param a   used to find terms in the query text.
     */
    public void setUp(String f, Analyzer a);

    /**Sets the fields of the query parser
     *  @param a           used to find terms in the query text.
     *  @param phraseSlop	the slop
     *  @param operator	the operator
     */
    public void setUp(Analyzer a, int phraseSlop, int operator);

    /** Sets the fields of the query parser
     *  @param f	the default field for query terms.
     *  @param a   used to find terms in the query text.
     *  @param phraseSlop	the slop
     *  @param operator	the operator
     */
    public void setUp(String f, Analyzer a, int phraseSlop, int operator);

    /** Sets the fields of the query parser
    *  @param f the default field for query terms.
    *  @param a used to find terms in the query text.
    *  @param sl  SearchLocations
    *  @param phraseSlop  the slop
    *  @param operator  the operator
    */
    public void setUp(String f, Analyzer a, SearchLocations sl, int phraseSlop, int operator);

    /** Parses a query string, returning a
     * <a href="lucene.search.Query.html">Query</a>.
     *  @param query	the query string to be parsed.
     *  @throws ParseException if the parsing fails
     *  @throws TokenMgrError if ther parsing fails
     */
    public Query parse(String query) throws ParseException, TokenMgrError;

    /**Get's the operator*/
    public int getOperator();

    /** Gets the default slop for phrases. */
    public int getPhraseSlop();

	/**
	 * Set the boolean operator of the QueryParser.
	 * In classic mode (<code>DEFAULT_OPERATOR_OR</mode>) terms without any modifiers
	 * are considered optional: for example <code>capital of Hungary</code> is equal to
	 * <code>capital OR of OR Hungary</code>.<br/>
	 * In <code>DEFAULT_OPERATOR_AND</code> terms are considered to be in conjuction: the
	 * above mentioned query is parsed as <code>capital AND of AND Hungary</code>
	 */
	public void setOperator(int i);

    /** Sets the default slop for phrases.  If zero, then exact phrase matches
     are required.  Zero by default. */
    public void setPhraseSlop(int i);


}
