/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.generator;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.language.LanguageException;
import org.apache.cocoon.components.language.generator.CompiledComponent;
import org.apache.cocoon.components.language.generator.GeneratorSelector;
import org.apache.cocoon.components.language.generator.ProgramGenerator;
import org.apache.cocoon.components.language.markup.MarkupLanguage;
import org.apache.cocoon.components.language.programming.CodeFormatter;
import org.apache.cocoon.components.language.programming.Program;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.IOUtils;
import org.apache.excalibur.source.Source;

public class ProgramGeneratorImpl
extends AbstractLogEnabled
implements ProgramGenerator,
Contextualizable,
Composable,
Parameterizable,
Disposable,
ThreadSafe {
    protected boolean autoReload = true;
    protected boolean preload = false;
    protected boolean watchSource = false;
    protected GeneratorSelector cache;
    protected ComponentManager manager;
    protected ComponentSelector markupSelector;
    protected ComponentSelector languageSelector;
    protected File workDir;
    protected ClassLoaderManager classManager;
    protected String rootPackage;
    protected String contextDir;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (this.workDir == null) {
            this.workDir = (File)context.get((Object)"work-directory");
        }
        if (this.contextDir == null) {
            Context ctx = (Context)context.get((Object)"environment-context");
            try {
                String rootPath = ctx.getRealPath("/");
                if (rootPath != null) {
                    this.contextDir = new File(rootPath).toURL().toExternalForm();
                } else {
                    String webInf = ctx.getResource("/WEB-INF").toExternalForm();
                    this.contextDir = webInf.substring(0, webInf.length() - "WEB-INF".length());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Context directory is " + this.contextDir);
                }
            }
            catch (MalformedURLException e) {
                this.getLogger().warn("Could not get context directory", (Throwable)e);
                this.contextDir = "";
            }
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        if (this.manager == null && manager != null) {
            this.manager = manager;
            this.cache = (GeneratorSelector)this.manager.lookup("org.apache.cocoon.components.language.generator.ServerPagesSelector");
            this.markupSelector = (ComponentSelector)this.manager.lookup(MarkupLanguage.ROLE + "Selector");
            this.languageSelector = (ComponentSelector)this.manager.lookup(ProgrammingLanguage.ROLE + "Selector");
            this.classManager = (ClassLoaderManager)this.manager.lookup(ClassLoaderManager.ROLE);
        }
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.autoReload = params.getParameterAsBoolean("auto-reload", this.autoReload);
        this.rootPackage = params.getParameter("root-package", "org.apache.cocoon.www");
        this.preload = params.getParameterAsBoolean("preload", this.preload);
        this.watchSource = params.getParameterAsBoolean("watch-source", this.watchSource);
    }

    private String getNormalizedName(String systemId) {
        StringBuffer contextFilename = new StringBuffer(this.rootPackage.replace('.', File.separatorChar));
        contextFilename.append(File.separator);
        if (systemId.startsWith(this.contextDir)) {
            contextFilename.append(systemId.substring(this.contextDir.length()));
        } else {
            contextFilename.append(systemId);
        }
        return IOUtils.normalizedFilename((String)contextFilename.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledComponent load(ComponentManager newManager, String fileName, String markupLanguageName, String programmingLanguageName, SourceResolver resolver) throws Exception {
        Source source = resolver.resolveURI(fileName);
        try {
            CompiledComponent compiledComponent = this.load(newManager, source, markupLanguageName, programmingLanguageName, resolver);
            return compiledComponent;
        }
        finally {
            resolver.release(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledComponent load(ComponentManager newManager, Source source, String markupLanguageName, String programmingLanguageName, SourceResolver resolver) throws Exception {
        CompiledComponent compiledComponent;
        String id = source.getURI();
        ProgrammingLanguage programmingLanguage = null;
        MarkupLanguage markupLanguage = null;
        try {
            CompiledComponent programInstance;
            Program program;
            String normalizedName;
            block42: {
                block41: {
                    normalizedName = this.getNormalizedName(id);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Loading serverpage systemId=[" + id + "]" + " markupLanguageName=[" + markupLanguageName + "]" + " programmingLanguageName=[" + programmingLanguageName + "]" + " -> normalizedName=[" + normalizedName + "]");
                    }
                    markupLanguage = (MarkupLanguage)this.markupSelector.select((Object)markupLanguageName);
                    programmingLanguage = (ProgrammingLanguage)this.languageSelector.select((Object)programmingLanguageName);
                    programmingLanguage.setLanguageName(programmingLanguageName);
                    program = null;
                    programInstance = null;
                    try {
                        programInstance = (CompiledComponent)this.cache.select(normalizedName);
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isDebugEnabled()) break block41;
                        this.getLogger().debug("The serverpage [" + id + "] is not in the cache yet");
                    }
                }
                if (programInstance == null && this.preload) {
                    try {
                        program = programmingLanguage.preload(normalizedName, this.workDir, markupLanguage.getEncoding());
                        this.cache.addGenerator(newManager, normalizedName, program);
                        programInstance = (CompiledComponent)this.cache.select(normalizedName);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Successfully preloaded serverpage [" + id + "]");
                        }
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isInfoEnabled()) break block42;
                        this.getLogger().info("The serverpage [" + id + "] could not be preloaded, will be re-created (" + e + ")");
                    }
                }
            }
            if (programInstance == null) {
                ProgramGeneratorImpl e = this;
                synchronized (e) {
                    try {
                        programInstance = (CompiledComponent)this.cache.select(normalizedName);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("The serverpage [" + id + "] was now in the cache");
                        }
                    }
                    catch (Exception e2) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Creating new serverpage for [" + id + "]");
                        }
                        this.generateSourcecode(source, normalizedName, markupLanguage, programmingLanguage);
                        programInstance = this.loadProgram(newManager, normalizedName, markupLanguage, programmingLanguage);
                    }
                }
            }
            if (this.autoReload) {
                long sourceLastModified = source.getLastModified();
                if (programInstance.modifiedSince(sourceLastModified)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("ReCreating serverpage for [" + id + "]");
                    }
                    ProgramGeneratorImpl programGeneratorImpl = this;
                    synchronized (programGeneratorImpl) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Releasing old serverpage program [" + id + "]");
                        }
                        this.release(programInstance);
                        programmingLanguage.unload(program, normalizedName, this.workDir);
                        this.cache.removeGenerator(normalizedName);
                        programInstance = null;
                        program = null;
                        this.generateSourcecode(source, normalizedName, markupLanguage, programmingLanguage);
                        programInstance = this.loadProgram(newManager, normalizedName, markupLanguage, programmingLanguage);
                    }
                } else if (this.watchSource) {
                    File sourcecodeFile;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Checking sourcecode of [" + id + "] for a change");
                    }
                    if ((sourcecodeFile = new File(this.workDir, normalizedName + "." + programmingLanguage.getSourceExtension())) != null && sourcecodeFile.exists()) {
                        long sourcecodeLastModified = sourcecodeFile.lastModified();
                        if (sourcecodeLastModified > sourceLastModified || sourceLastModified == 0L || sourcecodeLastModified == 0L) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Create new serverpage program for [" + id + "] - repository has changed");
                            }
                            ProgramGeneratorImpl programGeneratorImpl = this;
                            synchronized (programGeneratorImpl) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Releasing old serverpage program [" + id + "]");
                                }
                                this.release(programInstance);
                                this.cache.removeGenerator(normalizedName);
                                programInstance = null;
                                program = null;
                                programInstance = this.loadProgram(newManager, normalizedName, markupLanguage, programmingLanguage);
                            }
                        } else if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Sourcecode of [" + id + "] has not changed - returning program from cache");
                        }
                    } else if (this.getLogger().isErrorEnabled()) {
                        this.getLogger().error("Could not find sourcecode for [" + id + "]");
                    }
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Not checking for modifications [autoReload=false] - using current version");
            }
            if (programInstance instanceof Recomposable) {
                ((Recomposable)programInstance).recompose(newManager);
            }
            compiledComponent = programInstance;
            Object var20_25 = null;
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            this.markupSelector.release(markupLanguage);
            this.languageSelector.release(programmingLanguage);
            throw throwable;
        }
        this.markupSelector.release((Component)markupLanguage);
        this.languageSelector.release((Component)programmingLanguage);
        return compiledComponent;
    }

    private CompiledComponent loadProgram(ComponentManager newManager, String normalizedName, MarkupLanguage markupLanguage, ProgrammingLanguage programmingLanguage) throws Exception {
        CompiledComponent programInstance = null;
        try {
            return (CompiledComponent)this.cache.select(normalizedName);
        }
        catch (Exception e) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Loading program [" + normalizedName + "]");
                }
                Program program = programmingLanguage.load(normalizedName, this.workDir, markupLanguage.getEncoding());
                this.cache.addGenerator(newManager, normalizedName, program);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Successfully loaded program [" + normalizedName + "]");
                }
            }
            catch (LanguageException le) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Got Language Exception", (Throwable)((Object)le));
                }
                throw new ProcessingException("Language Exception", (Throwable)((Object)le));
            }
            try {
                programInstance = (CompiledComponent)this.cache.select(normalizedName);
            }
            catch (Exception cme) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Can't load ServerPage: got exception", (Throwable)cme);
                }
                throw new ProcessingException("Can't load ServerPage", (Throwable)cme);
            }
            return programInstance;
        }
    }

    private void generateSourcecode(Source source, String normalizedName, MarkupLanguage markupLanguage, ProgrammingLanguage programmingLanguage) throws Exception {
        File sourceFile;
        File sourceDir;
        String code;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating sourcecode for [" + source.getURI() + "]");
        }
        if ((code = markupLanguage.generateCode(source, normalizedName, programmingLanguage)) == null || code.length() == 0) {
            throw new ProcessingException("Failed to generate program code (this may happen if you use Xalan in incremental processing mode). Please check log file and/or console for errors.");
        }
        String encoding = markupLanguage.getEncoding();
        CodeFormatter codeFormatter = programmingLanguage.getCodeFormatter();
        if (codeFormatter != null) {
            code = codeFormatter.format(code, encoding);
        }
        if ((sourceDir = (sourceFile = new File(this.workDir, normalizedName + "." + programmingLanguage.getSourceExtension())).getParentFile()) != null) {
            sourceDir.mkdirs();
        }
        IOUtils.serializeString((File)sourceFile, (String)code);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Successfully created sourcecode for [" + source.getURI() + "]");
        }
    }

    public void release(CompiledComponent component) {
        this.cache.release(component);
    }

    public void remove(Source source) {
        String normalizedName = this.getNormalizedName(source.getURI());
        this.cache.removeGenerator(normalizedName);
    }

    public void dispose() {
        this.manager.release((Component)this.cache);
        this.cache = null;
        this.manager.release((Component)this.markupSelector);
        this.markupSelector = null;
        this.manager.release((Component)this.languageSelector);
        this.languageSelector = null;
        this.manager.release((Component)this.classManager);
        this.classManager = null;
        this.manager = null;
        this.workDir = null;
        this.contextDir = null;
    }
}

