/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.extended.SingleCharacter;

public class CharacterInterval {
    private SingleCharacter first = null;
    private SingleCharacter last = null;
    private String location = null;

    public void setFirstCharacter(SingleCharacter first) {
        if (this.last == null || this.last.getCharacter() < first.getCharacter()) {
            this.last = first;
        }
        this.first = first;
    }

    public SingleCharacter getFirstCharacter() {
        return this.first;
    }

    public void setLastCharacter(SingleCharacter last) {
        if (this.first == null || this.first.getCharacter() > last.getCharacter()) {
            this.first = last;
        }
        this.last = last;
    }

    public SingleCharacter getLastCharacter() {
        return this.last;
    }

    public void addSingleCharacter(SingleCharacter character) {
        if (character == null) {
            return;
        }
        if (this.getLastCharacter() != null) {
            this.setFirstCharacter(this.getLastCharacter());
        }
        this.setLastCharacter(character);
    }

    public SingleCharacter[] getSingleCharacters() {
        return new SingleCharacter[]{this.first, this.last};
    }

    public char[] getLimits() {
        return new char[]{this.first.getCharacter(), this.last.getCharacter()};
    }

    public boolean contains(char minimum, char maximum) {
        return this.first.getCharacter() <= minimum && minimum <= this.last.getCharacter() && this.first.getCharacter() <= maximum && maximum <= this.last.getCharacter();
    }

    public boolean contains(char c) {
        return this.first.getCharacter() <= c && c <= this.last.getCharacter();
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Decoder.decode(this.first.getCharacter(), "[^- ]"));
        buffer.append("-");
        buffer.append(Decoder.decode(this.last.getCharacter(), "[^- ]"));
        return buffer.toString();
    }

    public Object clone() {
        CharacterInterval clone = new CharacterInterval();
        clone.setFirstCharacter(this.getFirstCharacter());
        clone.setLastCharacter(this.getLastCharacter());
        return clone;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.first == null || this.last == null) {
            violations.addViolation("Interval is incomplete", this.getLocation());
        }
        if (this.first.getCharacter() > this.last.getCharacter()) {
            violations.addViolation("First is greater than the last", this.getLocation());
        }
        if (this.first.getCharacter() == this.last.getCharacter()) {
            violations.addViolation("First is equal than the last", this.getLocation());
        }
        return violations;
    }
}

