/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.CondItem;
import net.sf.pizzacompiler.compiler.ConstType;
import net.sf.pizzacompiler.compiler.DoubleConst;
import net.sf.pizzacompiler.compiler.FloatConst;
import net.sf.pizzacompiler.compiler.Gen;
import net.sf.pizzacompiler.compiler.IntConst;
import net.sf.pizzacompiler.compiler.Item;
import net.sf.pizzacompiler.compiler.LongConst;
import net.sf.pizzacompiler.compiler.Type;

class ImmediateItem
extends Item {
    ConstType value;

    ImmediateItem(ConstType constType) {
        super(Gen.typecode((Type)((Object)constType)));
        this.value = constType;
    }

    static Item make(ConstType constType) {
        return new ImmediateItem(constType);
    }

    private void ldc() {
        int n = Gen.putConstant(this.value);
        if (this.typecode == 1 || this.typecode == 3) {
            Gen.emitop(20, 2);
            Gen.emit2(n);
        } else if (n <= 255) {
            Gen.emitop(18, 1);
            Gen.emit1(n);
        } else {
            Gen.emitop(19, 1);
            Gen.emit2(n);
        }
    }

    Item load() {
        switch (this.typecode) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                int n = this.value.intValue();
                if (-1 <= n && n <= 5) {
                    Gen.emitop(3 + n);
                    break;
                }
                if (-128 <= n && n <= 127) {
                    Gen.emitop1(16, n);
                    break;
                }
                if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
                    Gen.emitop2(17, n);
                    break;
                }
                this.ldc();
                break;
            }
            case 1: {
                long l = this.value.longValue();
                if (l == 0L || l == 1L) {
                    Gen.emitop(9 + (int)l);
                    break;
                }
                this.ldc();
                break;
            }
            case 2: {
                float f = this.value.floatValue();
                if ((double)f == 0.0 || (double)f == 1.0 || (double)f == 2.0) {
                    Gen.emitop(11 + (int)f);
                    break;
                }
                this.ldc();
                break;
            }
            case 3: {
                double d = this.value.doubleValue();
                if (d == 0.0 || d == 1.0) {
                    Gen.emitop(14 + (int)d);
                    break;
                }
                this.ldc();
                break;
            }
            case 4: {
                this.ldc();
                break;
            }
            default: {
                throw new InternalError("load");
            }
        }
        return Item.stackItem[this.typecode];
    }

    CondItem mkCond() {
        int n = this.value.intValue();
        return CondItem.make(n != 0 ? 167 : Gen.dontgoto);
    }

    Item coerce(int n) {
        if (this.typecode == n) {
            return this;
        }
        switch (n) {
            case 0: {
                if (Gen.truncate(this.typecode) == 0) {
                    return this;
                }
                return new ImmediateItem(new IntConst(this.value.intValue()));
            }
            case 1: {
                return new ImmediateItem(new LongConst(this.value.longValue()));
            }
            case 2: {
                return new ImmediateItem(new FloatConst(this.value.floatValue()));
            }
            case 3: {
                return new ImmediateItem(new DoubleConst(this.value.doubleValue()));
            }
            case 5: {
                return new ImmediateItem(new IntConst(1, (byte)this.value.intValue()));
            }
            case 6: {
                return new ImmediateItem(new IntConst(2, (char)this.value.intValue()));
            }
            case 7: {
                return new ImmediateItem(new IntConst(3, (short)this.value.intValue()));
            }
        }
        return super.coerce(n);
    }
}

