/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.format.SyslogFormatter;
import org.apache.log.format.XMLFormatter;

public class FormatterFactory {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";

    public Formatter createFormatter(Configuration conf) {
        String type = conf.getAttribute("type", "pattern");
        String format = conf.getValue(FORMAT);
        if ("avalon".equals(type)) {
            int depth = conf.getAttributeAsInteger("depth", 8);
            boolean printCascading = conf.getAttributeAsBoolean("cascading", true);
            return new AvalonFormatter(format, depth, printCascading);
        }
        if ("extended".equals(type)) {
            return new ExtendedPatternFormatter(format, 1);
        }
        if ("raw".equals(type)) {
            return new RawFormatter();
        }
        if ("xml".equals(type)) {
            return new XMLFormatter();
        }
        if ("syslog".equals(type)) {
            return new SyslogFormatter();
        }
        if ("pattern".equals(type)) {
            return new PatternFormatter(format);
        }
        throw new IllegalArgumentException("Unknown formatter type " + type);
    }
}

