/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.util.Stack;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.event.impl.CopletLinkEvent;
import org.apache.cocoon.portal.transformation.AbstractCopletTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NewEventLinkTransformer
extends AbstractCopletTransformer {
    public static final String NAMESPACE_URI = "http://apache.org/cocoon/portal/eventlink/1.0";
    public static final String EVENT_ELEM = "eventlink";
    public static final String ATTRIBUTE_ATTR = "attribute";
    public static final String ELEMENT_ATTR = "element";
    private Stack elementStack = new Stack();

    public void recycle() {
        super.recycle();
        this.elementStack.clear();
    }

    public NewEventLinkTransformer() {
        this.namespaceURI = NAMESPACE_URI;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if (!EVENT_ELEM.equals(name)) {
            throw new SAXException("Unknown element encountered: " + name);
        }
        String attributeName = attributes.getValue(ATTRIBUTE_ATTR);
        String elementName = attributes.getValue(ELEMENT_ATTR);
        if (attributeName == null) {
            throw new SAXException("Element eventlink must have an attribute attribute.");
        }
        if (elementName == null) {
            throw new SAXException("Element eventlink must have an attribute element.");
        }
        AttributesImpl newAttributes = null;
        newAttributes = attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes);
        int i = newAttributes.getLength() - 1;
        while (i >= 0) {
            if (ELEMENT_ATTR.equals(attributes.getLocalName(i)) || ATTRIBUTE_ATTR.equals(attributes.getLocalName(i))) {
                newAttributes.removeAttribute(i);
            }
            --i;
        }
        int index = newAttributes.getIndex(attributeName);
        String link = newAttributes.getValue(index);
        boolean formSpecialTreatment = false;
        if ("form".equals(elementName)) {
            formSpecialTreatment = true;
            if ("GET".equalsIgnoreCase(newAttributes.getValue("method")) && link.indexOf(63) > 0) {
                link = link.substring(0, link.indexOf(63));
            }
        }
        String portalAction = null;
        String portalEvent = null;
        if (link != null) {
            CopletInstanceData cid = this.getCopletInstanceData();
            CopletLinkEvent event = new CopletLinkEvent(cid, link);
            String eventLink = this.getPortalService().getComponentManager().getLinkService().getLinkURI(event);
            if (formSpecialTreatment) {
                int begin = eventLink.indexOf("cocoon-portal-action=") + "cocoon-portal-action=".length();
                int end = eventLink.indexOf(38, begin);
                if (end == -1) {
                    end = eventLink.length();
                }
                portalAction = eventLink.substring(begin, end);
                begin = eventLink.indexOf("cocoon-portal-event=") + "cocoon-portal-event=".length();
                end = eventLink.indexOf(38, begin);
                if (end == -1) {
                    end = eventLink.length();
                }
                portalEvent = eventLink.substring(begin, end);
                eventLink = eventLink.substring(0, eventLink.indexOf(63));
            }
            newAttributes.setValue(index, eventLink);
        }
        this.elementStack.push(elementName);
        this.contentHandler.startElement("", elementName, elementName, newAttributes);
        if (formSpecialTreatment) {
            this.sendHiddenFields(this.contentHandler, portalAction, portalEvent);
        }
    }

    private void sendHiddenFields(ContentHandler contentHandler, String portalAction, String portalEvent) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "type", "type", "CDATA", "hidden");
        attributes.addAttribute("", "name", "name", "CDATA", "cocoon-portal-action");
        attributes.addAttribute("", "value", "value", "CDATA", portalAction);
        contentHandler.startElement("", "input", "input", attributes);
        contentHandler.endElement("", "input", "input");
        attributes = new AttributesImpl();
        attributes.addAttribute("", "type", "type", "CDATA", "hidden");
        attributes.addAttribute("", "name", "name", "CDATA", "cocoon-portal-event");
        attributes.addAttribute("", "value", "value", "CDATA", portalEvent);
        contentHandler.startElement("", "input", "input", attributes);
        contentHandler.endElement("", "input", "input");
    }

    public void endTransformingElement(String uri, String name, String raw) throws SAXException {
        String elementName = (String)this.elementStack.pop();
        this.contentHandler.endElement("", elementName, elementName);
    }
}

