/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.aspect.impl.DefaultAspectDescription;
import org.apache.cocoon.portal.event.impl.ChangeAspectDataEvent;
import org.apache.cocoon.portal.layout.CompositeLayout;
import org.apache.cocoon.portal.layout.Item;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.NamedItem;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.CompositeContentAspect;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TabContentAspect
extends CompositeContentAspect {
    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        if (layout instanceof CompositeLayout) {
            TabPreparedConfiguration config = (TabPreparedConfiguration)context.getAspectConfiguration();
            if (config.rootTag) {
                XMLUtils.startElement((ContentHandler)handler, (String)config.tagName);
            }
            AttributesImpl attributes = new AttributesImpl();
            CompositeLayout tabLayout = (CompositeLayout)layout;
            Integer data = (Integer)layout.getAspectData(config.aspectName);
            int selected = data;
            int j = 0;
            while (j < tabLayout.getSize()) {
                Item tab = tabLayout.getItem(j);
                attributes.clear();
                if (tab instanceof NamedItem) {
                    attributes.addCDATAAttribute("name", String.valueOf(((NamedItem)tab).getName()));
                }
                if (j == selected) {
                    attributes.addCDATAAttribute("selected", "true");
                } else {
                    ChangeAspectDataEvent event = new ChangeAspectDataEvent(tabLayout, config.aspectName, new Integer(j));
                    attributes.addCDATAAttribute("parameter", service.getComponentManager().getLinkService().getLinkURI(event));
                }
                Iterator iter = tab.getParameters().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    attributes.addCDATAAttribute((String)entry.getKey(), (String)entry.getValue());
                }
                XMLUtils.startElement((ContentHandler)handler, (String)"named-item", (Attributes)attributes);
                if (j == selected) {
                    this.processLayout(tab.getLayout(), service, handler);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"named-item");
                ++j;
            }
            if (config.rootTag) {
                XMLUtils.endElement((ContentHandler)handler, (String)config.tagName);
            }
        } else {
            throw new SAXException("Wrong layout type, TabLayout expected: " + layout.getClass().getName());
        }
    }

    public Iterator getAspectDescriptions(Object configuration) {
        TabPreparedConfiguration pc = (TabPreparedConfiguration)configuration;
        DefaultAspectDescription desc = new DefaultAspectDescription();
        desc.setName(pc.aspectName);
        desc.setClassName("java.lang.Integer");
        desc.setPersistence(pc.store);
        desc.setAutoCreate(true);
        return Collections.singletonList(desc).iterator();
    }

    public Object prepareConfiguration(Parameters configuration) throws ParameterException {
        TabPreparedConfiguration pc = new TabPreparedConfiguration();
        pc.takeValues((CompositeContentAspect.PreparedConfiguration)super.prepareConfiguration(configuration));
        pc.aspectName = configuration.getParameter("aspect-name", "tab");
        pc.store = configuration.getParameter("store");
        return pc;
    }

    protected class TabPreparedConfiguration
    extends CompositeContentAspect.PreparedConfiguration {
        public String aspectName;
        public String store;

        protected TabPreparedConfiguration() {
        }

        public void takeValues(TabPreparedConfiguration from) {
            super.takeValues(from);
            this.aspectName = from.aspectName;
            this.store = from.store;
        }
    }
}

