/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.log;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4JConfigurator
extends DOMConfigurator {
    protected Context context;
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;

    public Log4JConfigurator(Context context) {
        this.context = context;
    }

    protected String subst(String value) {
        try {
            return this.substVars(value);
        }
        catch (IllegalArgumentException e) {
            LogLog.warn((String)"Could not perform variable substitution.", (Throwable)e);
            return value;
        }
    }

    public String substVars(String val) throws IllegalArgumentException {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(DELIM_STOP, j);
            if (k == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j + '.');
            }
            String key = val.substring(j += DELIM_START_LEN, k);
            String replacement = this.getSystemProperty(key);
            if (replacement == null && this.context != null) {
                try {
                    Object o = this.context.get((Object)key);
                    if (o != null) {
                        replacement = o.toString();
                    }
                }
                catch (ContextException ce) {
                    LogLog.debug((String)("Was not allowed to read context property \"" + key + "\"."));
                }
            }
            if (replacement != null) {
                String recursiveReplacement = this.substVars(replacement);
                sbuf.append(recursiveReplacement);
            }
            i = k + DELIM_STOP_LEN;
        }
    }

    public String getSystemProperty(String key) {
        try {
            return System.getProperty(key, null);
        }
        catch (Throwable e) {
            LogLog.debug((String)("Was not allowed to read system property \"" + key + "\"."));
            return null;
        }
    }
}

