/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.incBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > this.buf.length - this.count) {
            this.incBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.realFlush();
        super.close();
    }

    public void realFlush() throws IOException {
        this.writeBuffer();
        this.out.flush();
    }

    private void writeBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.clearBuffer();
        }
    }

    private void incBuffer() {
        byte[] newBuf = new byte[this.buf.length * 2];
        System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
        this.buf = newBuf;
    }

    public void clearBuffer() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }
}

