/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractExtractionTransformer;
import org.apache.cocoon.xml.dom.DocumentWrapper;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleFormInstanceExtractionTransformer
extends AbstractExtractionTransformer
implements Configurable,
Serviceable {
    protected static final String OUTPUT_MODULE_SELECTOR = OutputModule.ROLE + "Selector";
    ElementData startElement = null;
    ElementData nameElement = null;
    String qname = "name";
    String instanceName = null;
    boolean nameAsRoot = true;
    String outputModuleName = "request-attr";
    Configuration outputConf = null;
    ServiceManager manager = null;
    Map objectModel = null;

    public void configure(Configuration config) throws ConfigurationException {
        this.startElement = new ElementData();
        this.startElement.uri = config.getChild("start").getAttribute("uri", "");
        this.startElement.loc = config.getChild("start").getAttribute("local-name", "form-instance");
        this.startElement.raw = config.getChild("start").getAttribute("raw-name", "form-instance");
        this.nameElement = new ElementData();
        this.nameElement.uri = config.getChild("name").getAttribute("uri", "");
        this.nameElement.loc = config.getChild("name").getAttribute("local-name", "form");
        this.nameElement.raw = config.getChild("name").getAttribute("raw-name", "form");
        this.qname = config.getChild("name").getAttribute("name-attribute", "name");
        this.nameAsRoot = config.getChild("name-as-root").getValueAsBoolean(this.nameAsRoot);
        this.outputConf = config.getChild("output");
        this.outputModuleName = this.outputConf.getAttribute("name", this.outputModuleName);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.objectModel = objectModel;
    }

    public void recycle() {
        super.recycle();
        this.instanceName = null;
    }

    public boolean startExtracting(String uri, String loc, String raw, Attributes a) {
        if (this.nameElement.equals(uri, loc, raw)) {
            this.instanceName = a.getValue(this.qname);
        }
        boolean res = this.startElement.equals(uri, loc, raw);
        return res;
    }

    public boolean endExtracting(String uri, String loc, String raw) {
        boolean res = this.startElement.equals(uri, loc, raw);
        return res;
    }

    public void startExtractingDocument(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (this.nameAsRoot) {
            loc = this.instanceName;
            if (uri != null && !uri.equals("")) {
                int pos = raw.indexOf(58);
                raw = raw.substring(0, pos + 1) + this.instanceName;
            } else {
                raw = loc;
            }
        }
        this.currentBuilder.startElement(uri, loc, raw, a);
    }

    public void endExtractingDocument(String uri, String loc, String raw) throws SAXException {
        if (this.nameAsRoot) {
            loc = this.instanceName;
            if (uri != null && !uri.equals("")) {
                int pos = raw.indexOf(58);
                raw = raw.substring(0, pos + 1) + this.instanceName;
            } else {
                raw = loc;
            }
        }
        this.currentBuilder.endElement(uri, loc, raw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleExtractedDocument(Document doc) {
        block12: {
            ServiceSelector outputSelector;
            block13: {
                outputSelector = null;
                OutputModule output = null;
                try {
                    block11: {
                        try {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("wrote ['" + this.instanceName + "'] to " + output + " using " + this.outputConf);
                            }
                            if ((outputSelector = (ServiceSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR)).isSelectable((Object)this.outputModuleName)) {
                                output = (OutputModule)outputSelector.select((Object)this.outputModuleName);
                            }
                            output.setAttribute(this.outputConf, this.objectModel, this.instanceName, new DocumentWrapper(doc));
                            output.commit(this.outputConf, this.objectModel);
                            if (!this.getLogger().isDebugEnabled()) break block11;
                            this.getLogger().debug("wrote ['" + this.instanceName + "'] to " + output + " using " + this.outputConf);
                        }
                        catch (Exception e) {
                            if (this.getLogger().isWarnEnabled()) {
                                this.getLogger().warn("Problem writing document data: " + e.getMessage());
                            }
                            Object var6_5 = null;
                            if (outputSelector != null) {
                                if (output != null) {
                                    outputSelector.release(output);
                                    output = null;
                                }
                                this.manager.release((Object)outputSelector);
                            }
                            break block12;
                        }
                    }
                    Object var6_4 = null;
                    if (outputSelector == null) break block12;
                    if (output == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (outputSelector != null) {
                        if (output != null) {
                            outputSelector.release(output);
                            output = null;
                        }
                        this.manager.release((Object)outputSelector);
                    }
                    throw throwable;
                }
                outputSelector.release((Object)output);
                output = null;
            }
            this.manager.release((Object)outputSelector);
        }
        this.instanceName = null;
    }

    protected static class ElementData {
        public String uri = null;
        public String loc = null;
        public String raw = null;

        public ElementData() {
        }

        public ElementData(String uri, String loc, String raw) {
            this.uri = uri;
            this.loc = loc;
            this.raw = raw;
        }

        public boolean equals(String uri, String loc, String raw) {
            if (!this.uri.equals(uri)) {
                return false;
            }
            if (!this.loc.equals(loc)) {
                return false;
            }
            return this.raw.equals(raw);
        }
    }
}

