/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.environment.Environment;

public class ComponentContext
extends DefaultContext {
    protected static final String OBJECT_MODEL_KEY_PREFIX = "object-model.";

    public ComponentContext(Map contextData, Context parent) {
        super(contextData, parent);
    }

    public ComponentContext(Map contextData) {
        super(contextData);
    }

    public ComponentContext(Context parent) {
        super(parent);
    }

    public ComponentContext() {
    }

    public Object get(Object key) throws ContextException {
        String stringKey;
        if ("object-model".equals(key)) {
            Environment env = CocoonComponentManager.getCurrentEnvironment();
            if (env == null) {
                throw new ContextException("Unable to locate " + key + " (No environment available)");
            }
            return env.getObjectModel();
        }
        if ("sitemap-service-manager".equals(key)) {
            ComponentManager manager = CocoonComponentManager.getSitemapComponentManager();
            if (manager == null) {
                throw new ContextException("Unable to locate " + key + " (No environment available)");
            }
            return new ComponentManagerWrapper(manager);
        }
        if (key instanceof String && (stringKey = (String)key).startsWith(OBJECT_MODEL_KEY_PREFIX)) {
            String objectKey;
            Environment env = CocoonComponentManager.getCurrentEnvironment();
            if (env == null) {
                throw new ContextException("Unable to locate " + key + " (No environment available)");
            }
            Map objectModel = env.getObjectModel();
            Object o = objectModel.get(objectKey = stringKey.substring(OBJECT_MODEL_KEY_PREFIX.length()));
            if (o == null) {
                String message = "Unable to locate " + key;
                throw new ContextException(message);
            }
            return o;
        }
        return super.get(key);
    }

    public static final class ComponentSelectorWrapper
    implements ServiceSelector {
        protected final ComponentSelector selector;

        public ComponentSelectorWrapper(ComponentSelector s) {
            this.selector = s;
        }

        public boolean isSelectable(Object role) {
            return this.selector.hasComponent(role);
        }

        public void release(Object role) {
            this.selector.release((Component)role);
        }

        public Object select(Object role) throws ServiceException {
            try {
                Object o = this.selector.select(role);
                if (o instanceof ComponentSelector) {
                    o = new ComponentSelectorWrapper((ComponentSelector)o);
                }
                return o;
            }
            catch (ComponentException ce) {
                throw new ServiceException("ComponentServiceWrapper", "Unable to lookup component: " + role, (Throwable)ce);
            }
        }

        public ComponentSelector getComponent() {
            return this.selector;
        }
    }

    public static final class ComponentManagerWrapper
    implements ServiceManager {
        protected final ComponentManager manager;

        public ComponentManagerWrapper(ComponentManager m) {
            this.manager = m;
        }

        public boolean hasService(String role) {
            return this.manager.hasComponent(role);
        }

        public Object lookup(String role) throws ServiceException {
            try {
                Object o = this.manager.lookup(role);
                if (o instanceof ComponentSelector) {
                    o = new ComponentSelectorWrapper((ComponentSelector)o);
                }
                return o;
            }
            catch (ComponentException ce) {
                throw new ServiceException("ComponentManagerWrapper", "Unable to lookup component: " + role, (Throwable)ce);
            }
        }

        public void release(Object c) {
            if (c instanceof ComponentSelectorWrapper) {
                c = ((ComponentSelectorWrapper)c).getComponent();
            }
            this.manager.release((Component)c);
        }
    }
}

