/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.http.AbstractXMLHandler;

public class XMLSnapshotHandler
extends AbstractXMLHandler {
    public XMLSnapshotHandler(DefaultInstrumentManager manager) {
        super("/snapshot.xml", manager);
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        InstrumentSampleDescriptor desc;
        String name = this.getParameter(parameters, "name");
        long baseTime = this.getLongParameter(parameters, "base-time", 0L);
        boolean packed = this.getBooleanParameter(parameters, "packed", false);
        boolean compact = this.getBooleanParameter(parameters, "compact", false);
        try {
            desc = this.getInstrumentManager().locateInstrumentSampleDescriptor(name);
        }
        catch (NoSuchInstrumentSampleException e) {
            throw new FileNotFoundException("The specified instrument sample does not exist: " + name);
        }
        out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.outputSampleHistory(out, desc, "", baseTime, packed, compact);
    }
}

