/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ComposerGenerator;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XMLDBGenerator
extends ComposerGenerator
implements CacheableProcessingComponent,
Configurable,
Initializable {
    protected String driver;
    protected String base;
    protected String col;
    protected String res;
    protected Database database;
    protected Collection collection;
    protected XMLResource xmlResource;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
    }

    public void recycle() {
        super.recycle();
        this.col = null;
        this.res = null;
        this.xmlResource = null;
        this.collection = null;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.driver = conf.getChild("driver").getValue();
        this.base = conf.getChild("base").getValue();
    }

    public void initialize() throws Exception {
        try {
            Class<?> c = Class.forName(this.driver);
            this.database = (Database)c.newInstance();
            DatabaseManager.registerDatabase((Database)this.database);
        }
        catch (XMLDBException xde) {
            this.getLogger().error("Unable to connect to the XML:DB database");
            throw new ProcessingException("Unable to connect to the XMLDB database: " + xde.getMessage());
        }
        catch (Exception e) {
            this.getLogger().error("There was a problem setting up the connection");
            this.getLogger().error("Make sure that your driver is available");
            throw new ProcessingException("Problem setting up the connection: " + e.getMessage());
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
    }

    public SourceValidity getValidity() {
        return null;
    }

    public Serializable getKey() {
        return null;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String col = "/";
        if (this.source.indexOf(47) != -1) {
            col = "/" + this.source.substring(0, this.source.lastIndexOf(47));
        }
        this.res = this.source.substring(this.source.lastIndexOf(47) + 1);
        try {
            this.collection = DatabaseManager.getCollection((String)(this.base + col));
            this.xmlResource = (XMLResource)this.collection.getResource(this.res);
            if (this.xmlResource == null) {
                throw new ResourceNotFoundException("Document " + col + "/" + this.res + " not found");
            }
            this.xmlResource.getContentAsSAX((ContentHandler)this.xmlConsumer);
            this.collection.close();
        }
        catch (XMLDBException xde) {
            throw new ProcessingException("Unable to fetch content: " + xde.getMessage());
        }
        catch (NullPointerException npe) {
            this.getLogger().error("The XML:DB driver raised an exception");
            this.getLogger().error("probably the document was not found");
            throw new ProcessingException("Null pointer exception while retrieving document : " + npe.getMessage());
        }
    }
}

