/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.admin;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.jcs.admin.CacheElementInfo;
import org.apache.jcs.admin.CacheRegionInfo;
import org.apache.jcs.admin.CountingOnlyOutputStream;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.memory.MemoryCache;

public class JCSAdminBean {
    private CompositeCacheManager cacheHub = CompositeCacheManager.getInstance();

    public LinkedList buildElementInfo(String cacheName) throws Exception {
        CompositeCache cache = this.cacheHub.getCache(cacheName);
        Object[] keys = cache.getMemoryCache().getKeyArray();
        try {
            Arrays.sort(keys);
        }
        catch (Exception e) {
            keys = cache.getMemoryCache().getKeyArray();
        }
        LinkedList<CacheElementInfo> records = new LinkedList<CacheElementInfo>();
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < keys.length) {
            ICacheElement element = cache.getMemoryCache().getQuiet((Serializable)keys[i]);
            IElementAttributes attributes = element.getElementAttributes();
            CacheElementInfo elementInfo = new CacheElementInfo();
            elementInfo.key = String.valueOf(keys[i]);
            elementInfo.eternal = attributes.getIsEternal();
            elementInfo.maxLifeSeconds = attributes.getMaxLifeSeconds();
            elementInfo.createTime = format.format(new Date(attributes.getCreateTime()));
            elementInfo.expiresInSeconds = (now - attributes.getCreateTime() - attributes.getMaxLifeSeconds() * 1000L) / -1000L;
            records.add(elementInfo);
            ++i;
        }
        return records;
    }

    public LinkedList buildCacheInfo() throws Exception {
        Object[] cacheNames = this.cacheHub.getCacheNames();
        Arrays.sort(cacheNames);
        LinkedList<CacheRegionInfo> cacheInfo = new LinkedList<CacheRegionInfo>();
        int i = 0;
        while (i < cacheNames.length) {
            CompositeCache cache = this.cacheHub.getCache((String)cacheNames[i]);
            CacheRegionInfo regionInfo = new CacheRegionInfo();
            regionInfo.cache = cache;
            regionInfo.byteCount = this.getByteCount(cache);
            cacheInfo.add(regionInfo);
            ++i;
        }
        return cacheInfo;
    }

    public int getByteCount(CompositeCache cache) throws Exception {
        MemoryCache memCache = cache.getMemoryCache();
        Iterator iter = memCache.getIterator();
        CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(counter);
        try {
            while (iter.hasNext()) {
                ICacheElement ce = (ICacheElement)((Map.Entry)iter.next()).getValue();
                out.writeObject(ce.getVal());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return counter.getCount() - 4;
    }

    public void clearAllRegions() throws IOException {
        String[] names = this.cacheHub.getCacheNames();
        int i = 0;
        while (i < names.length) {
            this.cacheHub.getCache(names[i]).removeAll();
            ++i;
        }
    }

    public void clearRegion(String cacheName) throws IOException {
        this.cacheHub.getCache(cacheName).removeAll();
    }

    public void removeItem(String cacheName, String key) throws IOException {
        this.cacheHub.getCache(cacheName).remove((Serializable)((Object)key));
    }
}

