/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractWidget
implements Widget {
    private Widget parent;
    private Form form;
    private List validators;
    private Map attributes;

    public String getId() {
        return this.getDefinition().getId();
    }

    protected abstract WidgetDefinition getDefinition();

    public String getLocation() {
        return this.getDefinition().getLocation();
    }

    public Widget getParent() {
        return this.parent;
    }

    public void setParent(Widget widget) {
        if (this.parent != null) {
            throw new IllegalStateException("The parent of widget " + this.getRequestParameterName() + " should only be set once.");
        }
        this.parent = widget;
    }

    public Form getForm() {
        Widget myParent = this.getParent();
        if (this.form == null) {
            this.form = myParent == null ? (Form)this : myParent.getForm();
        }
        return this.form;
    }

    public String getRequestParameterName() {
        String parentFullId;
        Widget myParent = this.getParent();
        if (myParent != null && (parentFullId = myParent.getRequestParameterName()).length() > 0) {
            return parentFullId + "." + this.getId();
        }
        return this.getId();
    }

    public Widget lookupWidget(String path) {
        Widget relativeWidget;
        if (path == null && path.equals("")) {
            return this;
        }
        String relativePath = null;
        int sepPosition = path.indexOf("/");
        if (sepPosition < 0) {
            if (path.startsWith("..")) {
                return this.getParent();
            }
            return this.getChild(path);
        }
        if (sepPosition == 0) {
            relativeWidget = this.getForm();
            relativePath = path.substring(1);
        } else if (path.startsWith("../")) {
            relativeWidget = this.getParent();
            relativePath = path.substring(3);
        } else {
            String childId = path.substring(0, sepPosition);
            relativeWidget = this.getChild(childId);
            relativePath = path.substring(sepPosition + 1);
        }
        if (relativeWidget == null) {
            return null;
        }
        return relativeWidget.lookupWidget(relativePath);
    }

    protected Widget getChild(String id) {
        return null;
    }

    public Widget getWidget(String id) {
        throw new UnsupportedOperationException("getWidget(id) got deprecated from the API. \nConsider using getChild(id) or even lookupWidget(path) instead.");
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object object) {
        throw new RuntimeException("Cannot set the value of widget " + this.getRequestParameterName());
    }

    public boolean isRequired() {
        return false;
    }

    public void broadcastEvent(WidgetEvent event) {
        throw new UnsupportedOperationException("Widget " + this.getRequestParameterName() + " doesn't handle events.");
    }

    public void addValidator(WidgetValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public boolean removeValidator(WidgetValidator validator) {
        if (this.validators != null) {
            return this.validators.remove(validator);
        }
        return false;
    }

    public boolean validate() {
        if (!this.getDefinition().validate(this)) {
            return false;
        }
        if (this.validators == null) {
            return true;
        }
        Iterator iter = this.validators.iterator();
        while (iter.hasNext()) {
            WidgetValidator validator = (WidgetValidator)iter.next();
            if (validator.validate(this)) continue;
            return false;
        }
        return true;
    }

    public void generateLabel(ContentHandler contentHandler) throws SAXException {
        this.getDefinition().generateDisplayData("label", contentHandler);
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
    }

    public abstract String getXMLElementName();

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = new AttributesImpl();
        if (this.getId().length() != 0) {
            attrs.addCDATAAttribute("id", this.getRequestParameterName());
        }
        return attrs;
    }

    public void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        this.getDefinition().generateDisplayData(contentHandler);
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        String element = this.getXMLElementName();
        AttributesImpl attrs = this.getXMLElementAttributes();
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", element, "fi:" + element, (Attributes)attrs);
        this.generateDisplayData(contentHandler);
        this.generateItemSaxFragment(contentHandler, locale);
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", element, "fi:" + element);
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }
}

