/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVMergeInfoHandler
extends BasicDAVHandler {
    private String myPath;
    private StringBuffer myCurrentInfo;
    private Map myPathsToMergeInfos;

    public static StringBuffer generateMergeInfoRequest(StringBuffer xmlBuffer, long revision, String[] paths, SVNMergeInfoInheritance inherit, boolean includeDescendants) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "mergeinfo-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "revision", String.valueOf(revision), xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "inherit", inherit.toString(), xmlBuffer);
        if (includeDescendants) {
            SVNXMLUtil.openCDataTag("S", "include-descendants", "yes", xmlBuffer);
        }
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                SVNXMLUtil.openCDataTag("S", "path", paths[i], xmlBuffer);
            }
        }
        SVNXMLUtil.addXMLFooter("S", "mergeinfo-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVMergeInfoHandler() {
        this.init();
        this.myPathsToMergeInfos = new TreeMap();
    }

    public Map getMergeInfo() {
        return this.myPathsToMergeInfos;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == DAVElement.MERGE_INFO_ITEM) {
            this.myPath = null;
            this.myCurrentInfo = null;
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == DAVElement.MERGE_INFO_PATH) {
            this.myPath = cdata.toString();
        } else if (element == DAVElement.MERGE_INFO_INFO) {
            this.myCurrentInfo = cdata;
        } else if (element == DAVElement.MERGE_INFO_ITEM && this.myPath != null && this.myCurrentInfo != null) {
            Map srcPathsToRangeLists = SVNMergeInfoUtil.parseMergeInfo(this.myCurrentInfo, null);
            this.myPathsToMergeInfos.put(this.myPath, new SVNMergeInfo(this.myPath, srcPathsToRangeLists));
        }
    }
}

