/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.tests;

import java.io.File;
import java.text.DecimalFormat;

public class CurrentDirectory {

    private static final File baseDirectory = new File("U:\\temp\\sdx");


    public static void main(String[] args) throws Exception {

        int depth = Integer.parseInt(args[0]);
        int extent = Integer.parseInt(args[1]);

        // And then we prepare a decimal format according to the extent.
        int l = (new Integer(extent)).toString().length();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < l; i++) {
            b.append("0");
        }
        DecimalFormat directoryFormat = new DecimalFormat(b.toString());

        // First get the random number
        for (int jj = 0; jj < 10; jj++) {
            int ran = (int) Math.round(Math.pow(extent, depth) * Math.random()) + 1;

            // Then iterate on the levels
            String[] parts = new String[depth];
            for (int i = 1; i <= depth; i++) {
                parts[i - 1] = formatDirectory(directoryFormat, getDirectory(i, ran, depth, extent));
            }

            // Then formats the complete directory name
            StringBuffer sb = new StringBuffer(baseDirectory.getCanonicalPath());
            for (int j = 0; j < parts.length; j++) {
                sb.append(File.separator + parts[j]);
            }
            System.err.println("" + ran + ": " + (new File(sb.toString())).getCanonicalPath());
        }
    }

    /**
     * Formats a directory named by an integer.
     */
    private static String formatDirectory(DecimalFormat directoryFormat, int number) {
        return directoryFormat.format(number);
    }

    /**
     * Returns a directory number.
     */
    private static int getDirectory(int level, int dirNo, int depth, int extent) {

        /*
            Pour extent = 10 et depth = 3, si j'ai 739, je dois retourner :

                - 8 au premier
                - 4 au second
                - 9 au troisieme

            1: 8 est le ceil de la division de 739 / 100 => (739 -   0) / (extent ^ (depth-level))
            2: 4 est le ceil de la division de 39 / 10   => (739 - 700) / (extent ^ (depth-level))
            3: 9 est le ceil de la division de  9 / 1    => (739 - 730) / (extent ^ (depth-level))

            Donc la partie difficile, c'est le 0, 700, 730, etc.

                1:   0 = 0
                2: 700 = floor( ( 739 / (extent ^ 2) ) ) * (extent ^ 2)
                3: 730 = floor( ( 739 / (extent ^ 1) ) ) * (extent ^ 1)

        */

        int offset = (int) Math.floor(dirNo / Math.pow(extent, (depth - level + 1))) * (int) Math.round(Math.pow(extent, (depth - level + 1)));
        double div = (dirNo - offset) / Math.pow(extent, (depth - level));
        int ret = (int) Math.round(Math.floor(div) + 1);
        return ret;

    }
}
