/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ant;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.ant.ConfigurableDocumentHandler;
import org.apache.lucene.ant.DocumentHandler;
import org.apache.lucene.ant.DocumentHandlerException;
import org.apache.lucene.ant.FileExtensionDocumentHandler;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class IndexTask
extends Task {
    private ArrayList filesets = new ArrayList();
    private boolean overwrite = false;
    private File indexDir;
    private String handlerClassName = FileExtensionDocumentHandler.class.getName();
    private DocumentHandler handler;
    private String analyzerClassName = StandardAnalyzer.class.getName();
    private Analyzer analyzer;
    private int mergeFactor = 20;
    private HandlerConfig handlerConfig;
    private boolean useCompoundIndex = true;
    static /* synthetic */ Class class$org$apache$lucene$analysis$SimpleAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$StopAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$WhitespaceAnalyzer;

    public void setIndex(File indexDir) {
        this.indexDir = indexDir;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setUseCompoundIndex(boolean useCompoundIndex) {
        this.useCompoundIndex = useCompoundIndex;
    }

    public void setDocumentHandler(String classname) {
        this.handlerClassName = classname;
    }

    public void setAnalyzer(AnalyzerType type) {
        this.analyzerClassName = type.getClassname();
    }

    public void setAnalyzerClassName(String classname) {
        this.analyzerClassName = classname;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addConfig(HandlerConfig config) throws BuildException {
        if (this.handlerConfig != null) {
            throw new BuildException("Only one config element allowed");
        }
        this.handlerConfig = config;
    }

    public void execute() throws BuildException {
        try {
            Class<?> clazz = Class.forName(this.handlerClassName);
            this.handler = (DocumentHandler)clazz.newInstance();
            clazz = Class.forName(this.analyzerClassName);
            this.analyzer = (Analyzer)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException((Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new BuildException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new BuildException((Throwable)iae);
        }
        this.log("Document handler = " + this.handler.getClass(), 3);
        this.log("Analyzer = " + this.analyzer.getClass(), 3);
        if (this.handler instanceof ConfigurableDocumentHandler) {
            ((ConfigurableDocumentHandler)this.handler).configure(this.handlerConfig.getProperties());
        }
        try {
            this.indexDocs();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexDocs() throws IOException {
        Date start = new Date();
        boolean create = this.overwrite;
        if (this.indexDir.mkdirs() && !this.overwrite) {
            create = true;
        }
        IndexSearcher searcher = null;
        boolean checkLastModified = false;
        if (!create) {
            try {
                searcher = new IndexSearcher(this.indexDir.getAbsolutePath());
                checkLastModified = true;
            }
            catch (IOException ioe) {
                this.log("IOException: " + ioe.getMessage());
            }
        }
        this.log("checkLastModified = " + checkLastModified, 3);
        IndexWriter writer = new IndexWriter(this.indexDir, this.analyzer, create);
        writer.setUseCompoundFile(this.useCompoundIndex);
        int totalFiles = 0;
        int totalIndexed = 0;
        int totalIgnored = 0;
        try {
            writer.setMergeFactor(this.mergeFactor);
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = (FileSet)this.filesets.get(i);
                if (fs == null) continue;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] dsfiles = ds.getIncludedFiles();
                File baseDir = ds.getBasedir();
                for (int j = 0; j < dsfiles.length; ++j) {
                    Document doc;
                    String indexModified;
                    Term pathTerm;
                    TermQuery query;
                    Hits hits;
                    File file = new File(baseDir, dsfiles[j]);
                    ++totalFiles;
                    if (!file.exists() || !file.canRead()) {
                        throw new BuildException("File \"" + file.getAbsolutePath() + "\" does not exist or is not readable.");
                    }
                    boolean indexIt = true;
                    if (checkLastModified && (hits = searcher.search((Query)(query = new TermQuery(pathTerm = new Term("path", file.getPath()))))).length() > 0 && (indexModified = (doc = hits.doc(0)).get("modified").trim()) != null) {
                        long lastModified = 0L;
                        try {
                            lastModified = DateTools.stringToTime((String)indexModified);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                        if (lastModified == file.lastModified()) {
                            indexIt = false;
                        }
                    }
                    if (!indexIt) continue;
                    try {
                        this.log("Indexing " + file.getPath(), 3);
                        Document doc2 = this.handler.getDocument(file);
                        if (doc2 == null) {
                            ++totalIgnored;
                            continue;
                        }
                        doc2.add((Fieldable)new Field("path", file.getPath(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                        doc2.add((Fieldable)new Field("modified", DateTools.timeToString((long)file.lastModified(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.UN_TOKENIZED));
                        writer.addDocument(doc2);
                        ++totalIndexed;
                        continue;
                    }
                    catch (DocumentHandlerException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
            }
            writer.optimize();
        }
        finally {
            writer.close();
            if (searcher != null) {
                searcher.close();
            }
        }
        Date end = new Date();
        this.log(totalIndexed + " out of " + totalFiles + " indexed (" + totalIgnored + " ignored) in " + (end.getTime() - start.getTime()) + " milliseconds");
    }

    public static class AnalyzerType
    extends EnumeratedAttribute {
        private static Map analyzerLookup = new HashMap();

        public String[] getValues() {
            Set keys = analyzerLookup.keySet();
            return keys.toArray(new String[0]);
        }

        public String getClassname() {
            return (String)analyzerLookup.get(this.getValue());
        }

        static {
            analyzerLookup.put("simple", (class$org$apache$lucene$analysis$SimpleAnalyzer == null ? (class$org$apache$lucene$analysis$SimpleAnalyzer = IndexTask.class$("org.apache.lucene.analysis.SimpleAnalyzer")) : class$org$apache$lucene$analysis$SimpleAnalyzer).getName());
            analyzerLookup.put("standard", (class$org$apache$lucene$analysis$standard$StandardAnalyzer == null ? (class$org$apache$lucene$analysis$standard$StandardAnalyzer = IndexTask.class$("org.apache.lucene.analysis.standard.StandardAnalyzer")) : class$org$apache$lucene$analysis$standard$StandardAnalyzer).getName());
            analyzerLookup.put("stop", (class$org$apache$lucene$analysis$StopAnalyzer == null ? (class$org$apache$lucene$analysis$StopAnalyzer = IndexTask.class$("org.apache.lucene.analysis.StopAnalyzer")) : class$org$apache$lucene$analysis$StopAnalyzer).getName());
            analyzerLookup.put("whitespace", (class$org$apache$lucene$analysis$WhitespaceAnalyzer == null ? (class$org$apache$lucene$analysis$WhitespaceAnalyzer = IndexTask.class$("org.apache.lucene.analysis.WhitespaceAnalyzer")) : class$org$apache$lucene$analysis$WhitespaceAnalyzer).getName());
        }
    }

    public static class HandlerConfig
    implements DynamicConfigurator {
        Properties props = new Properties();

        public void setDynamicAttribute(String attributeName, String value) throws BuildException {
            this.props.setProperty(attributeName, value);
        }

        public Object createDynamicElement(String elementName) throws BuildException {
            throw new BuildException("Sub elements not supported");
        }

        public Properties getProperties() {
            return this.props;
        }
    }
}

