/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.impl.DefaultInstrumentManagerImpl;
import org.apache.excalibur.instrument.manager.impl.InstrumentProxy;
import org.apache.excalibur.instrument.manager.impl.InstrumentableDescriptorImpl;
import org.apache.excalibur.instrument.manager.impl.XMLUtil;

class InstrumentableProxy
extends AbstractLogEnabled
implements Configurable {
    private DefaultInstrumentManagerImpl m_instrumentManager;
    private InstrumentableProxy m_parentInstrumentableProxy;
    private boolean m_configured;
    private boolean m_registered;
    private String m_name;
    private String m_description;
    private InstrumentableDescriptorImpl m_descriptor;
    private HashMap m_childInstrumentableProxies = new HashMap();
    private InstrumentableProxy[] m_childInstrumentableProxyArray;
    private InstrumentableDescriptor[] m_childInstrumentableDescriptorArray;
    private HashMap m_instrumentProxies = new HashMap();
    private InstrumentProxy[] m_instrumentProxyArray;
    private InstrumentDescriptor[] m_instrumentDescriptorArray;
    private int m_stateVersion;

    InstrumentableProxy(DefaultInstrumentManagerImpl instrumentManager, InstrumentableProxy parentInstrumentableProxy, String name, String description) {
        this.m_instrumentManager = instrumentManager;
        this.m_parentInstrumentableProxy = parentInstrumentableProxy;
        this.m_name = name;
        this.m_description = description;
        this.m_descriptor = new InstrumentableDescriptorImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_description = configuration.getAttribute("description", this.m_description);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Configuring Instrumentable: " + this.m_name + " as \"" + this.m_description + "\"");
            }
            this.m_configured = true;
            Configuration[] childConfs = configuration.getChildren("instrumentable");
            for (int i = 0; i < childConfs.length; ++i) {
                Configuration childConf = childConfs[i];
                String childName = childConf.getAttribute("name");
                String fullChildName = this.m_name + "." + childName;
                InstrumentableProxy childProxy = this.getChildInstrumentableProxy(fullChildName);
                if (childProxy == null) {
                    childProxy = new InstrumentableProxy(this.m_instrumentManager, this, fullChildName, childName);
                    childProxy.enableLogging(this.getLogger());
                    this.m_instrumentManager.incrementInstrumentableCount();
                    this.m_childInstrumentableProxies.put(fullChildName, childProxy);
                    this.m_childInstrumentableProxyArray = null;
                    this.m_childInstrumentableDescriptorArray = null;
                }
                childProxy.configure(childConf);
            }
            Configuration[] instrumentConfs = configuration.getChildren("instrument");
            for (int i = 0; i < instrumentConfs.length; ++i) {
                Configuration instrumentConf = instrumentConfs[i];
                String instrumentName = instrumentConf.getAttribute("name");
                String fullInstrumentName = this.m_name + "." + instrumentName;
                InstrumentProxy instrumentProxy = this.getInstrumentProxy(fullInstrumentName);
                if (instrumentProxy == null) {
                    instrumentProxy = new InstrumentProxy(this, fullInstrumentName, instrumentName);
                    instrumentProxy.enableLogging(this.getLogger());
                    this.m_instrumentManager.incrementInstrumentCount();
                    this.m_instrumentProxies.put(fullInstrumentName, instrumentProxy);
                    this.m_instrumentProxyArray = null;
                    this.m_instrumentDescriptorArray = null;
                }
                instrumentProxy.configure(instrumentConf);
            }
        }
    }

    DefaultInstrumentManagerImpl getInstrumentManager() {
        return this.m_instrumentManager;
    }

    InstrumentableProxy getParentInstrumentableProxy() {
        return this.m_parentInstrumentableProxy;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isRegistered() {
        return this.m_registered;
    }

    void setRegistered() {
        if (!this.m_registered) {
            this.m_registered = true;
            this.stateChanged();
        }
    }

    String getName() {
        return this.m_name;
    }

    void setDescription(String description) {
        String oldDescription = this.m_description;
        if (!(oldDescription == description || description != null && description.equals(oldDescription))) {
            this.m_description = description;
            this.stateChanged();
        }
    }

    String getDescription() {
        return this.m_description;
    }

    InstrumentableDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildInstrumentableProxy(InstrumentableProxy childInstrumentableProxy) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_childInstrumentableProxies.put(childInstrumentableProxy.getName(), childInstrumentableProxy);
            this.m_childInstrumentableProxyArray = null;
            this.m_childInstrumentableDescriptorArray = null;
        }
        this.stateChanged();
    }

    InstrumentableProxy getChildInstrumentableProxy(String childInstrumentableName) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            String name = childInstrumentableName;
            while (true) {
                InstrumentableProxy proxy;
                if ((proxy = (InstrumentableProxy)((Object)this.m_childInstrumentableProxies.get(name))) != null) {
                    return proxy;
                }
                int pos = name.lastIndexOf(46);
                if (pos <= 0) break;
                name = name.substring(0, pos);
            }
            return null;
        }
    }

    InstrumentableProxy[] getChildInstrumentableProxies() {
        InstrumentableProxy[] proxies = this.m_childInstrumentableProxyArray;
        if (proxies == null) {
            proxies = this.updateChildInstrumentableProxyArray();
        }
        return proxies;
    }

    InstrumentableDescriptor[] getChildInstrumentableDescriptors() {
        InstrumentableDescriptor[] descriptors = this.m_childInstrumentableDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateChildInstrumentableDescriptorArray();
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentableProxy[] updateChildInstrumentableProxyArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_childInstrumentableProxyArray = new InstrumentableProxy[this.m_childInstrumentableProxies.size()];
            this.m_childInstrumentableProxies.values().toArray(this.m_childInstrumentableProxyArray);
            Arrays.sort(this.m_childInstrumentableProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentableProxy)((Object)o1)).getDescription().compareTo(((InstrumentableProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            return this.m_childInstrumentableProxyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentableDescriptor[] updateChildInstrumentableDescriptorArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            if (this.m_childInstrumentableProxyArray == null) {
                this.updateChildInstrumentableProxyArray();
            }
            this.m_childInstrumentableDescriptorArray = new InstrumentableDescriptor[this.m_childInstrumentableProxyArray.length];
            for (int i = 0; i < this.m_childInstrumentableProxyArray.length; ++i) {
                this.m_childInstrumentableDescriptorArray[i] = this.m_childInstrumentableProxyArray[i].getDescriptor();
            }
            return this.m_childInstrumentableDescriptorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstrumentProxy(InstrumentProxy instrumentProxy) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_instrumentProxies.put(instrumentProxy.getName(), instrumentProxy);
            this.m_instrumentProxyArray = null;
            this.m_instrumentDescriptorArray = null;
        }
        this.stateChanged();
    }

    InstrumentProxy getInstrumentProxy(String instrumentName) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            String name = instrumentName;
            while (true) {
                InstrumentProxy proxy;
                if ((proxy = (InstrumentProxy)((Object)this.m_instrumentProxies.get(name))) != null) {
                    return proxy;
                }
                int pos = name.lastIndexOf(46);
                if (pos <= 0) break;
                name = name.substring(0, pos);
            }
            return null;
        }
    }

    InstrumentProxy[] getInstrumentProxies() {
        InstrumentProxy[] proxies = this.m_instrumentProxyArray;
        if (proxies == null) {
            proxies = this.updateInstrumentProxyArray();
        }
        return proxies;
    }

    InstrumentDescriptor[] getInstrumentDescriptors() {
        InstrumentDescriptor[] descriptors = this.m_instrumentDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateInstrumentDescriptorArray();
        }
        return descriptors;
    }

    int getStateVersion() {
        return this.m_stateVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentProxy[] updateInstrumentProxyArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_instrumentProxyArray = new InstrumentProxy[this.m_instrumentProxies.size()];
            this.m_instrumentProxies.values().toArray(this.m_instrumentProxyArray);
            Arrays.sort(this.m_instrumentProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentProxy)((Object)o1)).getDescription().compareTo(((InstrumentProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            return this.m_instrumentProxyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentDescriptor[] updateInstrumentDescriptorArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            if (this.m_instrumentProxyArray == null) {
                this.updateInstrumentProxyArray();
            }
            this.m_instrumentDescriptorArray = new InstrumentDescriptor[this.m_instrumentProxyArray.length];
            for (int i = 0; i < this.m_instrumentProxyArray.length; ++i) {
                this.m_instrumentDescriptorArray[i] = this.m_instrumentProxyArray[i].getDescriptor();
            }
            return this.m_instrumentDescriptorArray;
        }
    }

    boolean hasState() {
        InstrumentProxy[] proxies = this.getInstrumentProxies();
        for (int i = 0; i < proxies.length; ++i) {
            InstrumentProxy instrument = proxies[i];
            if (!instrument.hasState()) continue;
            return true;
        }
        InstrumentableProxy[] childProxies = this.getChildInstrumentableProxies();
        for (int i = 0; i < childProxies.length; ++i) {
            InstrumentableProxy instrumentable = childProxies[i];
            if (!instrumentable.hasState()) continue;
            return true;
        }
        return false;
    }

    void writeState(PrintWriter out) {
        out.print("<instrumentable name=\"");
        out.print(XMLUtil.getXMLSafeString(this.m_name));
        out.println("\">");
        InstrumentableProxy[] childProxies = this.getChildInstrumentableProxies();
        for (int i = 0; i < childProxies.length; ++i) {
            InstrumentableProxy instrumentable = childProxies[i];
            if (!instrumentable.hasState()) continue;
            instrumentable.writeState(out);
        }
        InstrumentProxy[] proxies = this.getInstrumentProxies();
        for (int i = 0; i < proxies.length; ++i) {
            InstrumentProxy instrument = proxies[i];
            if (!instrument.hasState()) continue;
            instrument.writeState(out);
        }
        out.println("</instrumentable>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadState(Configuration state) throws ConfigurationException {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            Configuration[] childConfs = state.getChildren("instrumentable");
            for (int i = 0; i < childConfs.length; ++i) {
                Configuration childConf = childConfs[i];
                String fullChildName = childConf.getAttribute("name");
                InstrumentableProxy childProxy = this.getChildInstrumentableProxy(fullChildName);
                if (childProxy == null) {
                    String childName = fullChildName.startsWith(this.m_name + ".") ? fullChildName.substring(this.m_name.length() + 1) : "BADNAME." + fullChildName;
                    childProxy = new InstrumentableProxy(this.m_instrumentManager, this, fullChildName, childName);
                    childProxy.enableLogging(this.getLogger());
                    this.m_instrumentManager.incrementInstrumentableCount();
                    this.m_childInstrumentableProxies.put(fullChildName, childProxy);
                    this.m_childInstrumentableProxyArray = null;
                    this.m_childInstrumentableDescriptorArray = null;
                }
                childProxy.loadState(childConf);
            }
            Configuration[] instrumentConfs = state.getChildren("instrument");
            for (int i = 0; i < instrumentConfs.length; ++i) {
                Configuration instrumentConf = instrumentConfs[i];
                String fullInstrumentName = instrumentConf.getAttribute("name");
                InstrumentProxy instrumentProxy = this.getInstrumentProxy(fullInstrumentName);
                if (instrumentProxy == null) {
                    String instrumentName = fullInstrumentName.startsWith(this.m_name + ".") ? fullInstrumentName.substring(this.m_name.length() + 1) : "BADNAME." + fullInstrumentName;
                    instrumentProxy = new InstrumentProxy(this, fullInstrumentName, instrumentName);
                    instrumentProxy.enableLogging(this.getLogger());
                    this.m_instrumentManager.incrementInstrumentCount();
                    this.m_instrumentProxies.put(fullInstrumentName, instrumentProxy);
                    this.m_instrumentProxyArray = null;
                    this.m_instrumentDescriptorArray = null;
                }
                instrumentProxy.loadState(instrumentConf);
            }
        }
        this.stateChanged();
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
        if (this.m_parentInstrumentableProxy == null) {
            this.m_instrumentManager.stateChanged();
        } else {
            this.m_parentInstrumentableProxy.stateChanged();
        }
    }
}

