/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail.datasource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cocoon.mail.datasource.AbstractDataSource;
import org.apache.excalibur.source.SourceUtil;

public class InputStreamDataSource
extends AbstractDataSource {
    private byte[] data;

    public InputStreamDataSource(InputStream in) throws IOException {
        this(in, null, null);
    }

    public InputStreamDataSource(byte[] data, String type, String name) {
        super(InputStreamDataSource.getName(name), InputStreamDataSource.getType(type));
        this.data = data == null ? new byte[0] : data;
    }

    public InputStreamDataSource(InputStream in, String type, String name) throws IOException {
        super(InputStreamDataSource.getName(name), InputStreamDataSource.getType(type));
        if (in == null) {
            this.data = new byte[0];
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SourceUtil.copy((InputStream)in, (OutputStream)out);
            this.data = out.toByteArray();
        }
    }

    private static String getName(String name) {
        if (InputStreamDataSource.isNullOrEmpty(name)) {
            name = "attachment";
        }
        return name;
    }

    private static String getType(String type) {
        if (InputStreamDataSource.isNullOrEmpty(type)) {
            type = "application/octet-stream";
        }
        return type;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }
}

