/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Provider;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.mail.MailCommandBuilder;
import org.apache.cocoon.mail.MailCommandManager;
import org.apache.cocoon.mail.MailContentHandlerDelegate;
import org.apache.cocoon.mail.MailContext;
import org.apache.cocoon.mail.MailContextHttpSession;
import org.apache.cocoon.mail.command.AbstractMailCommand;

public class MailAction
extends ServiceableAction
implements ThreadSafe {
    public static final String REQUEST_ATTRIBUTE_FOLDER = "folder";
    public static final String REQUEST_ATTRIBUTE_FOLDERS = "folders";
    public static final String REQUEST_ATTRIBUTE_MESSAGE = "message";
    public static final String REQUEST_ATTRIBUTE_MESSAGES = "messages";

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters par) throws Exception {
        Session mailSession;
        HashMap<String, String> actionMap = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String command = request.getParameter("cmd");
        String folderName = request.getParameter(REQUEST_ATTRIBUTE_FOLDER);
        String userid = request.getParameter("mail-userid");
        String password = request.getParameter("mail-password");
        org.apache.cocoon.environment.Session session = request.getSession(true);
        MailContext mailContext = (MailContext)((Object)session.getAttribute("mail-context"));
        if (mailContext == null) {
            mailContext = new MailContextHttpSession(null);
            mailContext.enableLogging(this.getLogger());
            session.setAttribute("mail-context", (Object)mailContext);
        }
        try {
            try {
                mailSession = (Session)mailContext.get("mail-session");
            }
            catch (ContextException ce) {
                Properties sessionProperties = new Properties();
                String[] allParameterNames = par.getNames();
                for (int i = 0; i < allParameterNames.length; ++i) {
                    String parameterName = allParameterNames[i];
                    String PARAMETER_NAME_PREFIX = "javax.mail.Session.props:";
                    if (!parameterName.startsWith("javax.mail.Session.props:")) continue;
                    String sessionPropName = parameterName.substring("javax.mail.Session.props:".length());
                    String sessionPropValue = par.getParameter(parameterName, null);
                    if (sessionPropValue == null) continue;
                    this.getLogger().debug("Add session property " + String.valueOf(sessionPropName) + ": " + String.valueOf(sessionPropValue));
                    sessionProperties.put(sessionPropName, sessionPropValue);
                }
                mailSession = Session.getDefaultInstance((Properties)sessionProperties, null);
                this.checkProviders(mailSession);
                mailContext.put("mail-session", mailSession);
            }
        }
        catch (Exception e) {
            String message = "Cannot create mail session";
            this.getLogger().error(message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
        String storeURLNameExpanded = null;
        String storeURLNameTemplate = par.getParameter("store-urlname", null);
        try {
            try {
                Store mailStore = (Store)mailContext.get("mail-store");
            }
            catch (ContextException ce) {
                storeURLNameExpanded = this.getURLNameExpanded(storeURLNameTemplate, userid, password);
                URLName urlNameExpanded = new URLName(storeURLNameExpanded);
                this.getLogger().info("get store using URLName " + String.valueOf(urlNameExpanded));
                Store mailStore = mailSession.getStore(urlNameExpanded);
                mailStore.connect();
                mailContext.put("mail-store", mailStore);
            }
        }
        catch (Exception e) {
            String message = "Cannot get store, and connect " + String.valueOf(storeURLNameExpanded);
            this.getLogger().error(message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
        if (folderName != null) {
            mailContext.put("mail-current-working-folder", folderName);
        } else {
            folderName = (String)mailContext.get("mail-current-working-folder");
        }
        actionMap.put("mail-current-working-folder", folderName);
        if (command != null) {
            mailContext.put("mail-current-working-command", command);
        } else {
            command = (String)mailContext.get("mail-current-working-command");
        }
        actionMap.put("mail-current-working-command", command);
        mailContext.setRequest(request);
        this.populateRequestAttribute(request, mailContext);
        mailContext.setRequest(null);
        return actionMap;
    }

    protected String getURLNameExpanded(String storeURLNameTemplate, String userid, String password) {
        String tokenStart = "''";
        String tokenEnd = "''";
        Properties filters = new Properties();
        filters.put("mail-userid", userid);
        filters.put("mail-passwd", password);
        return this.filter(tokenStart, tokenEnd, storeURLNameTemplate, filters);
    }

    protected String filter(String tokenStart, String tokenEnd, String s, Properties tokens) {
        int index = s.indexOf(tokenStart);
        if (index > -1) {
            try {
                int endIndex;
                StringBuffer b = new StringBuffer();
                int i = 0;
                while ((endIndex = s.indexOf(tokenEnd, index + tokenStart.length() + 1)) != -1) {
                    String token = s.substring(index + tokenStart.length(), endIndex);
                    b.append(s.substring(i, index));
                    if (tokens.containsKey(token)) {
                        String value = (String)tokens.get(token);
                        b.append(value);
                        i = index + tokenStart.length() + token.length() + tokenEnd.length();
                    } else {
                        b.append(tokenStart);
                        i = index + tokenStart.length();
                    }
                    if ((index = s.indexOf(tokenStart, i)) > -1) continue;
                }
                b.append(s.substring(i));
                return b.toString();
            }
            catch (StringIndexOutOfBoundsException e) {
                return s;
            }
        }
        return s;
    }

    protected void checkProviders(Session session) {
        Provider[] providers = session.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            this.getLogger().info("mail provider " + providers[i]);
        }
    }

    protected void populateRequestAttribute(Request request, MailContext mailContext) throws Exception {
        String folderName = (String)mailContext.get("mail-current-working-folder");
        request.setAttribute("mail-current-working-folder", (Object)folderName);
        String command = (String)mailContext.get("mail-current-working-command");
        request.setAttribute("mail-current-working-command", (Object)command);
        List javaMailResult = this.retrieveJavaMailObjects(mailContext);
        Iterator javaMailResultIterator = javaMailResult.iterator();
        this.putXMLizerToRequestAttribute(request, javaMailResultIterator);
    }

    protected void putXMLizerToRequestAttribute(Request request, Iterator resultIterator) {
        if (resultIterator != null) {
            Logger logger = this.getLogger();
            String datePattern = "dd.MM.yyyy HH:mm";
            SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
            while (resultIterator.hasNext()) {
                Object objRef = resultIterator.next();
                this.getLogger().debug("Creating XMLizer for " + String.valueOf(objRef));
                if (objRef instanceof Folder) {
                    MailContentHandlerDelegate.FolderXMLizer fx = new MailContentHandlerDelegate.FolderXMLizer((Folder)objRef);
                    fx.enableLogging(logger);
                    request.setAttribute(REQUEST_ATTRIBUTE_FOLDER, (Object)fx);
                    continue;
                }
                if (objRef instanceof Folder[]) {
                    Folder[] folders = (Folder[])objRef;
                    MailContentHandlerDelegate.FolderXMLizer[] fxs = new MailContentHandlerDelegate.FolderXMLizer[folders.length];
                    for (int i = 0; i < folders.length; ++i) {
                        fxs[i] = new MailContentHandlerDelegate.FolderXMLizer(folders[i]);
                        fxs[i].enableLogging(logger);
                    }
                    request.setAttribute(REQUEST_ATTRIBUTE_FOLDERS, (Object)fxs);
                    continue;
                }
                if (objRef instanceof Message) {
                    MailContentHandlerDelegate.MessageXMLizer mx = new MailContentHandlerDelegate.MessageXMLizer((Message)objRef);
                    mx.enableLogging(logger);
                    mx.setSimpleDateFormat(sdf);
                    request.setAttribute(REQUEST_ATTRIBUTE_MESSAGE, (Object)mx);
                    continue;
                }
                if (!(objRef instanceof Message[])) continue;
                MailContentHandlerDelegate.MessageEnvelopeXMLizer mex = new MailContentHandlerDelegate.MessageEnvelopeXMLizer((Message[])objRef);
                mex.enableLogging(logger);
                mex.setSimpleDateFormat(sdf);
                request.setAttribute(REQUEST_ATTRIBUTE_MESSAGES, (Object)mex);
            }
        }
    }

    protected List retrieveJavaMailObjects(MailContext mailContext) throws ProcessingException {
        try {
            MailCommandManager mam = new MailCommandManager();
            mam.enableLogging(this.getLogger());
            MailCommandBuilder mab = new MailCommandBuilder();
            mab.enableLogging(this.getLogger());
            AbstractMailCommand ama = mab.buildAbstractMailCommand(mailContext);
            this.getLogger().debug("Executing " + String.valueOf(ama));
            List result = mam.execute(ama);
            return result;
        }
        catch (Exception e) {
            String message = "Cannot retrieve javamail objects";
            this.getLogger().error(message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
    }
}

