/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IMAPGenerator
extends AbstractGenerator {
    static final String URI = "http://apache.org/cocoon/imap/1.0/";
    static final String PREFIX = "imap";
    private String host;
    private String user;
    private String pass;
    private Properties props = new Properties();
    private Message[] message;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.host = par.getParameter("host", "none");
        this.user = par.getParameter("user", "none");
        this.pass = par.getParameter("pass", "none");
        if (this.host.equals("none") || this.user.equals("none") || this.pass.equals("none")) {
            throw new ProcessingException("You must configure this generator with host, user, and pass parameters.");
        }
    }

    public void generate() throws SAXException, ProcessingException {
        try {
            Session sess = Session.getDefaultInstance((Properties)this.props, null);
            Store st = sess.getStore(PREFIX);
            this.log("Connecting to IMAP server @ " + this.host);
            st.connect(this.host, this.user, this.pass);
            this.log("Attempting to open default folder");
            Folder f = st.getFolder("inbox");
            f.open(2);
            this.log("Downloading message list from folder");
            this.message = f.getMessages();
            int i = 0;
            this.log("Starting XML generation");
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(PREFIX, URI);
            this.start(PREFIX, XMLUtils.EMPTY_ATTRIBUTES);
            this.start("messages", XMLUtils.EMPTY_ATTRIBUTES);
            for (i = 0; i < this.message.length; ++i) {
                this.start("msg", XMLUtils.EMPTY_ATTRIBUTES);
                this.start("subject", XMLUtils.EMPTY_ATTRIBUTES);
                this.data(this.message[i].getSubject());
                this.end("subject");
                this.start("from", XMLUtils.EMPTY_ATTRIBUTES);
                this.data(this.message[i].getFrom()[0].toString());
                this.end("from");
                this.start("sentDate", XMLUtils.EMPTY_ATTRIBUTES);
                this.data(this.message[i].getSentDate().toString());
                this.end("sentDate");
                this.start("num", XMLUtils.EMPTY_ATTRIBUTES);
                this.data(Integer.toString(this.message[i].getMessageNumber()));
                this.end("num");
                this.end("msg");
            }
            this.end("messages");
            this.end(PREFIX);
            this.contentHandler.endPrefixMapping(PREFIX);
            this.contentHandler.endDocument();
            this.log("Finished generating XML");
        }
        catch (AuthenticationFailedException afe) {
            throw new ProcessingException("Failed to authenticate with the IMAP server.");
        }
        catch (Exception e) {
            throw new ProcessingException(e.toString());
        }
    }

    public void recycle() {
        this.host = null;
        this.user = null;
        this.pass = null;
        this.props = null;
        this.message = null;
        super.recycle();
    }

    private void start(String name, Attributes attr) throws SAXException {
        this.contentHandler.startElement(URI, name, "imap:" + name, attr);
    }

    private void end(String name) throws SAXException {
        this.contentHandler.endElement(URI, name, "imap:" + name);
    }

    private void data(String data) throws SAXException {
        this.contentHandler.characters(data.toCharArray(), 0, data.length());
    }

    private void log(String msg) {
        this.getLogger().debug(msg);
    }
}

