/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLGeneralOutput;
import com.icl.saxon.tree.AttributeCollection;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLOutput
extends XSLGeneralOutput {
    public void prepareAttributes() throws TransformerConfigurationException {
        super.prepareAttributes();
        if (this.href != null) {
            this.compileError("The href attribute is not allowed on this element");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.checkEmpty();
    }

    public void process(Context context) throws TransformerException {
    }

    protected Properties gatherOutputProperties(Properties properties) {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        if (this.method != null) {
            ((Hashtable)properties).put("method", attributeCollection.getValueByFingerprint(standardNames.METHOD));
        }
        if (this.version != null) {
            ((Hashtable)properties).put("version", attributeCollection.getValueByFingerprint(standardNames.VERSION));
        }
        if (this.indent != null) {
            ((Hashtable)properties).put("indent", attributeCollection.getValueByFingerprint(standardNames.INDENT));
        }
        if (this.indentSpaces != null) {
            ((Hashtable)properties).put("{http://icl.com/saxon}indent-spaces", attributeCollection.getValueByFingerprint(standardNames.SAXON_INDENT_SPACES));
        }
        if (this.encoding != null) {
            ((Hashtable)properties).put("encoding", attributeCollection.getValueByFingerprint(standardNames.ENCODING));
        }
        if (this.mediaType != null) {
            ((Hashtable)properties).put("media-type", attributeCollection.getValueByFingerprint(standardNames.MEDIA_TYPE));
        }
        if (this.doctypeSystem != null) {
            ((Hashtable)properties).put("doctype-system", attributeCollection.getValueByFingerprint(standardNames.DOCTYPE_SYSTEM));
        }
        if (this.doctypePublic != null) {
            ((Hashtable)properties).put("doctype-public", attributeCollection.getValueByFingerprint(standardNames.DOCTYPE_PUBLIC));
        }
        if (this.omitDeclaration != null) {
            ((Hashtable)properties).put("omit-xml-declaration", attributeCollection.getValueByFingerprint(standardNames.OMIT_XML_DECLARATION));
        }
        if (this.standalone != null) {
            ((Hashtable)properties).put("standalone", attributeCollection.getValueByFingerprint(standardNames.STANDALONE));
        }
        if (this.cdataElements != null) {
            String string = properties.getProperty("cdata-section-elements");
            String string2 = string + " " + attributeCollection.getValueByFingerprint(standardNames.CDATA_SECTION_ELEMENTS);
            ((Hashtable)properties).put("cdata-section-elements", string2);
        }
        if (this.nextInChain != null) {
            // empty if block
        }
        return properties;
    }
}

