/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplet.adapter.CopletAdapter;
import org.apache.cocoon.serialization.Serializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CopletSource
implements Source,
XMLizable,
Serviceable,
Contextualizable {
    protected ServiceManager manager;
    protected Context context;
    protected String uri;
    protected String copletControllerName;
    protected CopletInstanceData copletInstanceData;
    protected String scheme;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public CopletSource(String location, String protocol, CopletInstanceData coplet) {
        this.uri = location;
        this.scheme = protocol == null ? "coplet" : protocol;
        this.copletInstanceData = coplet;
        this.copletControllerName = this.copletInstanceData.getCopletData().getCopletBaseData().getCopletAdapterName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        try {
            ByteArrayInputStream byteArrayInputStream;
            ServiceSelector serializerSelector;
            ServiceManager sitemapManager;
            block9: {
                sitemapManager = (ServiceManager)this.context.get((Object)"sitemap-service-manager");
                serializerSelector = null;
                Serializer serializer = null;
                try {
                    try {
                        serializerSelector = (ServiceSelector)sitemapManager.lookup(Serializer.ROLE + "Selector");
                        serializer = (Serializer)serializerSelector.select((Object)"xml");
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        serializer.setOutputStream((OutputStream)os);
                        this.toSAX((ContentHandler)serializer);
                        byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                        Object var7_9 = null;
                        if (serializer == null) break block9;
                    }
                    catch (SAXException se) {
                        throw new CascadingIOException("Unable to stream content.", (Throwable)se);
                    }
                    catch (ServiceException ce) {
                        throw new CascadingIOException("Unable to get components for serializing.", (Throwable)ce);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (serializer != null) {
                        serializerSelector.release(serializer);
                    }
                    sitemapManager.release(serializerSelector);
                    throw throwable;
                }
                serializerSelector.release((Object)serializer);
            }
            sitemapManager.release((Object)serializerSelector);
            return byteArrayInputStream;
        }
        catch (ContextException ce) {
            throw new CascadingIOException("Unable to get service manager.", (Throwable)ce);
        }
    }

    public String getURI() {
        return this.uri;
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void refresh() {
    }

    public String getMimeType() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        ServiceSelector copletAdapterSelector;
        block5: {
            copletAdapterSelector = null;
            CopletAdapter copletAdapter = null;
            try {
                copletAdapterSelector = (ServiceSelector)this.manager.lookup(CopletAdapter.ROLE + "Selector");
                copletAdapter = (CopletAdapter)copletAdapterSelector.select((Object)this.copletControllerName);
                copletAdapter.toSAX(this.copletInstanceData, handler);
                if (null == copletAdapter) break block5;
            }
            catch (ServiceException ce) {
                try {
                    throw new SAXException("Unable to lookup coplet adaptor or adaptor selector.", (Exception)((Object)ce));
                }
                catch (Throwable throwable) {
                    if (null != copletAdapter) {
                        copletAdapterSelector.release(copletAdapter);
                    }
                    this.manager.release(copletAdapterSelector);
                    throw throwable;
                }
            }
            copletAdapterSelector.release((Object)copletAdapter);
        }
        this.manager.release((Object)copletAdapterSelector);
    }

    public boolean exists() {
        return true;
    }

    public String getScheme() {
        return this.scheme;
    }
}

