/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.pluto.factory;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.util.ClassUtils;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.invoker.PortletInvoker;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletDefinition;

public class LocalPortletInvokerImpl
extends AbstractLogEnabled
implements PortletInvoker,
Contextualizable,
Serviceable,
Initializable {
    protected final ServletConfig servletConfig;
    protected final PortletDefinition portletDefinition;
    protected Portlet portlet;
    protected Context context;
    protected ServiceManager manager;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() throws Exception {
        block2: {
            if (this.portlet == null) break block2;
            try {
                ContainerUtil.enableLogging((Object)this.portlet, (Logger)this.getLogger());
                ContainerUtil.contextualize((Object)this.portlet, (Context)this.context);
                ContainerUtil.service((Object)this.portlet, (ServiceManager)this.manager);
                ContainerUtil.initialize((Object)this.portlet);
            }
            catch (Exception ignore) {
                this.getLogger().warn("Unable to initialize local portlet invoker.", (Throwable)ignore);
                this.portlet = null;
            }
        }
    }

    public LocalPortletInvokerImpl(PortletDefinition portletDefinition, ServletConfig servletConfig) {
        this.portletDefinition = portletDefinition;
        this.servletConfig = servletConfig;
        try {
            String clazzName = portletDefinition.getClassName();
            this.portlet = (Portlet)ClassUtils.newInstance((String)clazzName);
        }
        catch (Exception ignore) {
            this.getLogger().warn("Unable to initialize local portlet invoker.", (Throwable)ignore);
        }
    }

    public void action(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (this.portlet == null) {
            throw new PortletException("Unable to instantiate portlet from class " + this.portletDefinition.getClassName());
        }
        this.portlet.processAction(request, response);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.portlet == null) {
            throw new PortletException("Unable to instantiate portlet from class " + this.portletDefinition.getClassName());
        }
        this.portlet.render(request, response);
    }

    public void load(PortletRequest request, RenderResponse response) throws PortletException {
        if (this.portlet == null) {
            throw new PortletException("Unable to instantiate portlet from class " + this.portletDefinition.getClassName());
        }
        PortletContext portletContext = PortletObjectAccess.getPortletContext((ServletContext)this.servletConfig.getServletContext(), (PortletApplicationDefinition)this.portletDefinition.getPortletApplicationDefinition());
        PortletConfig portletConfig = PortletObjectAccess.getPortletConfig((ServletConfig)this.servletConfig, (PortletContext)portletContext, (PortletDefinition)this.portletDefinition);
        this.portlet.init(portletConfig);
    }

    public void destroy() {
        if (this.portlet != null) {
            this.portlet.destroy();
            this.portlet = null;
        }
    }
}

