/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.portal.coplet.CopletBaseData;
import org.apache.cocoon.portal.factory.impl.AbstractProducible;
import org.apache.cocoon.portal.util.DeltaApplicable;

public class CopletData
extends AbstractProducible
implements DeltaApplicable {
    protected String title;
    protected CopletBaseData copletBaseData;
    protected Map attributes = new HashMap();
    private boolean deltaApplied = false;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CopletBaseData getCopletBaseData() {
        return this.copletBaseData;
    }

    public void setCopletBaseData(CopletBaseData copletBaseData) {
        this.copletBaseData = copletBaseData;
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public boolean applyDelta(Object object) {
        CopletBaseData copletBaseData;
        CopletData data = (CopletData)object;
        this.deltaApplied = true;
        String title = data.getTitle();
        if (title != null) {
            this.setTitle(title);
        }
        if ((copletBaseData = data.getCopletBaseData()) != null) {
            this.setCopletBaseData(copletBaseData);
        }
        Iterator iterator = data.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            Object delta = entry.getValue();
            Object attribute = this.getAttribute(key);
            if (attribute == null) {
                this.setAttribute(key, delta);
                continue;
            }
            if (attribute instanceof DeltaApplicable) {
                boolean success = ((DeltaApplicable)attribute).applyDelta(delta);
                if (success) continue;
                this.setAttribute(key, delta);
                continue;
            }
            this.setAttribute(key, delta);
        }
        return true;
    }

    public boolean deltaApplied() {
        return this.deltaApplied;
    }
}

