/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.environment.Environment;

public class SitemapErrorHandler {
    private ErrorHandlerHelper handler;
    private Environment environment;
    private InvokeContext context;
    private String envPrefix;
    private String envURI;
    private String envContext;

    public SitemapErrorHandler(ErrorHandlerHelper handler, Environment environment, InvokeContext context) {
        this.handler = handler;
        this.environment = environment;
        this.context = context;
        this.envPrefix = environment.getURIPrefix();
        this.envURI = environment.getURI();
        this.envContext = environment.getContext();
    }

    public boolean handleError(Exception e) throws Exception {
        this.environment.setContext(this.envPrefix, this.envURI, this.envContext);
        return this.handler.invokeErrorHandler(e, this.environment, this.context);
    }

    public ProcessingPipeline prepareErrorPipeline(Exception e) throws Exception {
        this.environment.setContext(this.envPrefix, this.envURI, this.envContext);
        return this.handler.prepareErrorHandler(e, this.environment, this.context);
    }
}

