/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.Constants;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StatusGenerator
extends ServiceableGenerator
implements Contextualizable,
Configurable {
    public static final String NAMESPACE = "http://apache.org/cocoon/status/2.0";
    protected static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    protected static final String XLINK_PREFIX = "xlink";
    protected Context context;
    protected StoreJanitor storeJanitor;
    protected Store storePersistent;
    private boolean showLibrary;
    private Source libDirectory;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.showLibrary = configuration.getChild("show-libraries").getValueAsBoolean(true);
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        if (this.manager.hasService(StoreJanitor.ROLE)) {
            this.storeJanitor = (StoreJanitor)manager.lookup(StoreJanitor.ROLE);
        } else {
            this.getLogger().info("StoreJanitor is not available. Sorry, no cache statistics");
        }
        if (this.manager.hasService(Store.PERSISTENT_STORE)) {
            this.storePersistent = (Store)this.manager.lookup(Store.PERSISTENT_STORE);
        } else {
            this.getLogger().info("Persistent Store is not available. Sorry no cache statistics about it.");
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        if (this.showLibrary) {
            try {
                this.libDirectory = this.resolver.resolveURI("context://WEB-INF/lib");
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.storePersistent);
            this.manager.release((Object)this.storeJanitor);
            this.storePersistent = null;
            this.storeJanitor = null;
        }
        if (this.libDirectory != null) {
            this.resolver.release(this.libDirectory);
            this.libDirectory = null;
        }
        super.dispose();
    }

    public void generate() throws SAXException, ProcessingException {
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", NAMESPACE);
        this.contentHandler.startPrefixMapping(XLINK_PREFIX, XLINK_NS);
        this.genStatus();
        this.contentHandler.endPrefixMapping(XLINK_PREFIX);
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }

    private void genStatus() throws SAXException, ProcessingException {
        String localHost;
        String dateTime = DateFormat.getDateTimeInstance().format(new Date());
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.getLogger().debug("StatusGenerator:UnknownHost", (Throwable)e);
            localHost = "";
        }
        catch (SecurityException e) {
            this.getLogger().debug("StatusGenerator:Security", (Throwable)e);
            localHost = "";
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute(NAMESPACE, "date", dateTime);
        atts.addCDATAAttribute(NAMESPACE, "host", localHost);
        atts.addCDATAAttribute(NAMESPACE, "cocoon-version", Constants.VERSION);
        this.contentHandler.startElement(NAMESPACE, "statusinfo", "statusinfo", atts);
        this.genVMStatus();
        this.genProperties();
        if (this.showLibrary) {
            this.genLibrarylist();
        }
        this.contentHandler.endElement(NAMESPACE, "statusinfo", "statusinfo");
    }

    private void genVMStatus() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.startGroup("VM");
        String classpath = SystemUtils.JAVA_CLASS_PATH;
        if (classpath != null) {
            ArrayList<String> paths = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(classpath, SystemUtils.PATH_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                paths.add(tokenizer.nextToken());
            }
            this.addMultilineValue("classpath", paths);
        }
        String contextClassPath = null;
        try {
            contextClassPath = (String)this.context.get((Object)"classpath");
        }
        catch (ContextException e) {
            // empty catch block
        }
        if (contextClassPath != null) {
            ArrayList<String> paths = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(contextClassPath, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                paths.add(tokenizer.nextToken());
            }
            this.addMultilineValue("context-classpath", paths);
        }
        this.startGroup("Memory");
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        this.addValue("total", String.valueOf(totalMemory));
        this.addValue("used", String.valueOf(totalMemory - freeMemory));
        this.addValue("free", String.valueOf(freeMemory));
        this.endGroup();
        this.startGroup("JRE");
        this.addValue("version", SystemUtils.JAVA_VERSION);
        atts.clear();
        atts.addAttribute(XLINK_NS, "type", "xlink:type", "CDATA", "simple");
        atts.addAttribute(XLINK_NS, "href", "xlink:href", "CDATA", SystemUtils.JAVA_VENDOR_URL);
        this.addValue("java-vendor", SystemUtils.JAVA_VENDOR, atts);
        this.endGroup();
        this.startGroup("Operating System");
        this.addValue("name", SystemUtils.OS_NAME);
        this.addValue("architecture", SystemUtils.OS_ARCH);
        this.addValue("version", SystemUtils.OS_VERSION);
        this.endGroup();
        if (this.storeJanitor != null) {
            this.startGroup("Store Janitor");
            Iterator i = this.storeJanitor.iterator();
            while (i.hasNext()) {
                Store store = (Store)i.next();
                this.startGroup(store.getClass().getName() + " (hash = 0x" + Integer.toHexString(store.hashCode()) + ")");
                int size = 0;
                int empty = 0;
                atts.clear();
                atts.addAttribute(NAMESPACE, "name", "name", "CDATA", "cached");
                this.contentHandler.startElement(NAMESPACE, "value", "value", atts);
                atts.clear();
                Enumeration e = store.keys();
                while (e.hasMoreElements()) {
                    ++size;
                    Object key = e.nextElement();
                    Object val = store.get(key);
                    if (val == null) {
                        ++empty;
                        continue;
                    }
                    String line = key + " (class: " + val.getClass().getName() + ")";
                    this.contentHandler.startElement(NAMESPACE, "line", "line", atts);
                    this.contentHandler.characters(line.toCharArray(), 0, line.length());
                    this.contentHandler.endElement(NAMESPACE, "line", "line");
                }
                if (size == 0) {
                    this.contentHandler.startElement(NAMESPACE, "line", "line", atts);
                    String value = "[empty]";
                    this.contentHandler.characters(value.toCharArray(), 0, value.length());
                    this.contentHandler.endElement(NAMESPACE, "line", "line");
                }
                this.contentHandler.endElement(NAMESPACE, "value", "value");
                this.addValue("size", String.valueOf(size) + " items in cache (" + empty + " are empty)");
                this.endGroup();
            }
            this.endGroup();
        }
        if (this.storePersistent != null) {
            this.startGroup(this.storePersistent.getClass().getName() + " (hash = 0x" + Integer.toHexString(this.storePersistent.hashCode()) + ")");
            int size = 0;
            int empty = 0;
            atts.clear();
            atts.addAttribute(NAMESPACE, "name", "name", "CDATA", "cached");
            this.contentHandler.startElement(NAMESPACE, "value", "value", atts);
            atts.clear();
            Enumeration e = this.storePersistent.keys();
            while (e.hasMoreElements()) {
                ++size;
                Object key = e.nextElement();
                Object val = this.storePersistent.get(key);
                if (val == null) {
                    ++empty;
                    continue;
                }
                String line = key + " (class: " + val.getClass().getName() + ")";
                this.contentHandler.startElement(NAMESPACE, "line", "line", atts);
                this.contentHandler.characters(line.toCharArray(), 0, line.length());
                this.contentHandler.endElement(NAMESPACE, "line", "line");
            }
            if (size == 0) {
                this.contentHandler.startElement(NAMESPACE, "line", "line", atts);
                String value = "[empty]";
                this.contentHandler.characters(value.toCharArray(), 0, value.length());
                this.contentHandler.endElement(NAMESPACE, "line", "line");
            }
            this.contentHandler.endElement(NAMESPACE, "value", "value");
            this.addValue("size", size + " items in cache (" + empty + " are empty)");
            this.endGroup();
        }
        this.endGroup();
    }

    private void genProperties() throws SAXException {
        this.startGroup("System-Properties");
        Properties p = System.getProperties();
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            this.addValue(key, value);
        }
        this.endGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genLibrarylist() throws SAXException, ProcessingException {
        block8: {
            try {
                Iterator i3;
                Iterator i2;
                if (!(this.libDirectory instanceof TraversableSource)) break block8;
                this.startGroup("WEB-INF/lib");
                TreeSet<String> files = new TreeSet<String>();
                Collection kids = ((TraversableSource)this.libDirectory).getChildren();
                try {
                    i2 = kids.iterator();
                    while (i2.hasNext()) {
                        Source lib = (Source)i2.next();
                        String name = lib.getURI().substring(lib.getURI().lastIndexOf(47) + 1);
                        files.add(name);
                    }
                    Object var7_7 = null;
                    i3 = kids.iterator();
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    Iterator i3 = kids.iterator();
                    while (i3.hasNext()) {
                        Source lib = (Source)i3.next();
                        this.resolver.release(lib);
                    }
                    throw throwable;
                }
                while (i3.hasNext()) {
                    Source lib = (Source)i3.next();
                    this.resolver.release(lib);
                }
                i2 = files.iterator();
                while (i2.hasNext()) {
                    this.addValue("file", (String)i2.next());
                }
                this.endGroup();
            }
            catch (SourceException e) {
                throw new ResourceNotFoundException("Could not read directory", e);
            }
        }
    }

    private void startGroup(String name) throws SAXException {
        this.startGroup(name, null);
    }

    private void startGroup(String name, Attributes atts) throws SAXException {
        AttributesImpl ai = atts == null ? new AttributesImpl() : new AttributesImpl(atts);
        ai.addAttribute(NAMESPACE, "name", "name", "CDATA", name);
        this.contentHandler.startElement(NAMESPACE, "group", "group", ai);
    }

    private void endGroup() throws SAXException {
        this.contentHandler.endElement(NAMESPACE, "group", "group");
    }

    private void addValue(String name, String value) throws SAXException {
        this.addValue(name, value, null);
    }

    private void addValue(String name, String value, Attributes atts) throws SAXException {
        AttributesImpl ai = atts == null ? new AttributesImpl() : new AttributesImpl(atts);
        ai.addAttribute(NAMESPACE, "name", "name", "CDATA", name);
        this.contentHandler.startElement(NAMESPACE, "value", "value", ai);
        this.contentHandler.startElement(NAMESPACE, "line", "line", XMLUtils.EMPTY_ATTRIBUTES);
        if (value != null) {
            this.contentHandler.characters(value.toCharArray(), 0, value.length());
        }
        this.contentHandler.endElement(NAMESPACE, "line", "line");
        this.contentHandler.endElement(NAMESPACE, "value", "value");
    }

    private void addMultilineValue(String name, List values) throws SAXException {
        this.addMultilineValue(name, values, null);
    }

    private void addMultilineValue(String name, List values, Attributes atts) throws SAXException {
        AttributesImpl ai = atts == null ? new AttributesImpl() : new AttributesImpl(atts);
        ai.addAttribute(NAMESPACE, "name", "name", "CDATA", name);
        this.contentHandler.startElement(NAMESPACE, "value", "value", ai);
        for (int i = 0; i < values.size(); ++i) {
            String value = (String)values.get(i);
            if (value == null) continue;
            this.contentHandler.startElement(NAMESPACE, "line", "line", XMLUtils.EMPTY_ATTRIBUTES);
            this.contentHandler.characters(value.toCharArray(), 0, value.length());
            this.contentHandler.endElement(NAMESPACE, "line", "line");
        }
        this.contentHandler.endElement(NAMESPACE, "value", "value");
    }
}

