/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cocoon.components.cron.JobSchedulerEntry;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzJobSchedulerEntry
implements JobSchedulerEntry {
    private final JobDataMap m_data;
    private final JobDetail m_detail;
    private final Scheduler m_scheduler;
    private final SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String m_name;
    private final Trigger m_trigger;

    public QuartzJobSchedulerEntry(String name, Scheduler scheduler) throws SchedulerException {
        this.m_scheduler = scheduler;
        this.m_name = name;
        this.m_detail = this.m_scheduler.getJobDetail(name, "Cocoon");
        this.m_data = this.m_detail.getJobDataMap();
        this.m_trigger = this.m_scheduler.getTrigger(name, "Cocoon");
    }

    public String getJobName() {
        String name = (String)this.m_data.get((Object)"QuartzJobScheduler.ROLE");
        if (null == name) {
            name = this.m_data.get((Object)"QuartzJobScheduler.Object").getClass().getName();
        }
        return name;
    }

    public String getName() {
        return this.m_name;
    }

    public Date getNextTime() {
        return this.m_trigger.getNextFireTime();
    }

    public boolean isRunning() {
        Boolean runs = (Boolean)this.m_data.get((Object)"QuartzJobExecutor.isRunning");
        if (null != runs) {
            return runs;
        }
        return false;
    }

    public String getSchedule() {
        if (this.m_trigger instanceof CronTrigger) {
            return "cron: " + ((CronTrigger)this.m_trigger).getCronExpression();
        }
        if (this.m_trigger instanceof SimpleTrigger) {
            if (((SimpleTrigger)this.m_trigger).getRepeatInterval() == 0L) {
                return "once: at " + this.m_formatter.format(this.m_trigger.getFinalFireTime());
            }
            return "periodic: every " + ((SimpleTrigger)this.m_trigger).getRepeatInterval() / 1000L + "s";
        }
        return "next: " + this.m_formatter.format(this.m_trigger.getNextFireTime());
    }
}

