/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public class HexBinaryValue
extends AtomicValue {
    private byte[] binaryValue;

    public HexBinaryValue(CharSequence charSequence) throws XPathException {
        CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
        if ((charSequence2.length() & 1) != 0) {
            DynamicError dynamicError = new DynamicError("A hexBinary value must contain an even number of characters");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.binaryValue = new byte[charSequence2.length() / 2];
        for (int i = 0; i < this.binaryValue.length; ++i) {
            this.binaryValue[i] = (byte)((this.fromHex(charSequence2.charAt(2 * i)) << 4) + this.fromHex(charSequence2.charAt(2 * i + 1)));
        }
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    public HexBinaryValue(CharSequence charSequence, AtomicType atomicType) {
        if ((charSequence.length() & 1) != 0) {
            throw new IllegalArgumentException("A hexBinary value must contain an even number of characters");
        }
        this.binaryValue = new byte[charSequence.length() / 2];
        try {
            for (int i = 0; i < this.binaryValue.length; ++i) {
                this.binaryValue[i] = (byte)((this.fromHex(charSequence.charAt(2 * i)) << 4) + this.fromHex(charSequence.charAt(2 * i + 1)));
            }
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
        this.typeLabel = atomicType;
    }

    public HexBinaryValue(byte[] byArray) {
        this.binaryValue = byArray;
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    public AtomicValue copy(AtomicType atomicType) {
        HexBinaryValue hexBinaryValue = new HexBinaryValue(this.binaryValue);
        hexBinaryValue.typeLabel = atomicType;
        return hexBinaryValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.HEX_BINARY;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    private int fromHex(char c) throws XPathException {
        int n = "0123456789ABCDEFabcdef".indexOf(c);
        if (n > 15) {
            n -= 6;
        }
        if (n < 0) {
            DynamicError dynamicError = new DynamicError("Invalid hexadecimal digit");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        return n;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 527: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 528: {
                return new Base64BinaryValue(this.binaryValue);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert hexBinarry to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        String string = "0123456789ABCDEF";
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.binaryValue.length * 2);
        for (int i = 0; i < this.binaryValue.length; ++i) {
            fastStringBuffer.append(string.charAt(this.binaryValue[i] >> 4 & 0xF));
            fastStringBuffer.append(string.charAt(this.binaryValue[i] & 0xF));
        }
        return fastStringBuffer.toString();
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(HexBinaryValue.class)) {
            return this;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of hexBinary to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public boolean equals(Object object) {
        HexBinaryValue hexBinaryValue;
        if (object instanceof HexBinaryValue) {
            hexBinaryValue = (HexBinaryValue)object;
        } else if (object instanceof AtomicValue) {
            try {
                hexBinaryValue = (HexBinaryValue)((AtomicValue)object).convert(BuiltInAtomicType.HEX_BINARY, null);
            }
            catch (XPathException xPathException) {
                return false;
            }
        } else {
            return false;
        }
        if (this.binaryValue.length != hexBinaryValue.binaryValue.length) {
            return false;
        }
        for (int i = 0; i < this.binaryValue.length; ++i) {
            if (this.binaryValue[i] == hexBinaryValue.binaryValue[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }
}

